/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _WS_ALERT_MSG_OBJ_H_
#define _WS_ALERT_MSG_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <string.h>

#include "standard.h"
#include "osal.h"
#include "sms_api.h"
#include "dsrl_entry_obj.h"
#include "string_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define WS_ALERT_MSG_OBJECT_NAME "WS_ALERT_MSG"
#define WS_ALERTS_MSG_SHORT_BUFFER_SIZE OSAL_ASCBUFSIZE

#define WS_ALERTS_MARINE_FLAG_MASK      (0x80)
#define WS_ALERTS_IS_MARINE_ZONE(stateid) \
    ((BOOLEAN)(((stateid) & WS_ALERTS_MARINE_FLAG_MASK) != 0 ? TRUE : FALSE))

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct ws_alert_msg_object_struct
{
    WS_ALERT_MSG_ID tMsgId;
    UN8 un8StateId;
    SMS_LANGUAGE_ENUM eMsgLang;
    STRING_OBJECT hMsgText;
    TIME_T tEventStartTime;
    TIME_T tEventEndTime;
    size_t tPriority;
    //External reference
    OSAL_OBJECT_HDL hMsgTypesList;
    // Number of locations this message valid for
    UN8 un8NumLocations;
    OSAL_OBJECT_HDL hLocationsList;

    //Application callback
    WS_ALERT_MSG_TYPES_ITERATOR_CALLBACK bCallback;
    void *pvCallbackArg;
} WS_ALERT_MSG_OBJECT_STRUCT;

// An iterator structure used to print wsalerts locations.
typedef struct ws_alert_msg_print_iterator_struct
{
    FILE *psFile;
    N32 n32NumBytesWritten;
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption;
} WS_ALERT_MSG_PRINT_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hMsgText (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static STRING_OBJECT hAlertText (
    WS_ALERT_MSG_OBJECT hAlertMsg,
    STRING_OBJECT hAlertType
        );

static TIME_T tStartTime (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static TIME_T tEndTime (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static SMS_LANGUAGE_ENUM eMsgLang (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static UN16 un16Priority (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static SMSAPI_RETURN_CODE_ENUM eIterateLocations (
    WS_ALERT_MSG_OBJECT hAlertMsg,
    WS_ALERT_MSG_LOCATIONS_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eIterateAlertTypes (
    WS_ALERT_MSG_OBJECT hAlertMsg,
    WS_ALERT_MSG_TYPES_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

static WS_ALERT_MSG_ID tID (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static BOOLEAN bIsMarineZone (
    WS_ALERT_MSG_OBJECT hAlertMsg
        );

static N32 n32FPrintf (
    WS_ALERT_MSG_OBJECT hAlertMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */
static void vDestroyObject(
    WS_ALERT_MSG_OBJECT_STRUCT *psObj
        );

static BOOLEAN bPrintTypeIterator (
    void *pvData,
    WS_ALERT_MSG_PRINT_ITERATOR_STRUCT *psIterator
        );

static BOOLEAN bPrintLocationIterator (
    void *pvData,
    WS_ALERT_MSG_PRINT_ITERATOR_STRUCT *psIterator
        );

  /***************/
 /** VARIABLES **/
/***************/
// Global (re-usable) instance of an interface for this object
const WS_ALERT_MSG_OBJECT_INTERFACE_STRUCT WS_ALERT_MSG = {
    /* hMsgText = */          hMsgText,
    /* hAlertText = */        hAlertText,
    /* tStartTime = */        tStartTime,
    /* tEndTime = */          tEndTime,
    /* eMsgLang = */          eMsgLang,
    /* un16Priority = */      un16Priority,
    /* eIterateLocations = */ eIterateLocations,
    /* eIterateAlertTypes = */eIterateAlertTypes,
    /* tId = */               tID,
    /* bIsMarineZone = */     bIsMarineZone,
    /* n32FPrintf = */        n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _WS_ALERT_MSG_OBJ_H_
