/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _WIND_OBJ_H_
#define _WIND_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define WIND_OBJECT_NAME "WIND"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct wind_object_struct
{
	BOOLEAN bAvailable;
	WIND_DATA_STRUCT sData;
} WIND_OBJECT_STRUCT;


//Prototypes
static SMSAPI_RETURN_CODE_ENUM eDirection (
	WIND_OBJECT hWind,
	UN16 *pun16WindDirection
		);

static SMSAPI_RETURN_CODE_ENUM eSpeed (
	WIND_OBJECT hWind,
	UN8 *pun8WindSpeed
		);

static N32 n32FPrintf (
	WIND_OBJECT hWind,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const WIND_OBJECT_INTERFACE_STRUCT WIND =
{
	/*.eDirection = */eDirection,
	/*.eSpeed = */eSpeed,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _WIND_OBJ_H_ */
