/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TW_NOW private header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _TW_NOW_OBJ_H_
#define _TW_NOW_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define TW_NOW_OBJECT_NAME "TW_NOW"

/* Minimal Protocol Version for feature support */
#define TW_NOW_PROTOCOL_SUPPORT_MIN_VERSION \
    MODULE_PROTOCOL_VERSION_PACK(3, 0, 0)

  /**************/
 /** TYPEDEFS **/
/**************/

//  The TW_NOW_SERVICE structure
typedef struct tw_now_object_struct
{
    /* THINGS PROVIDED BY APPLICATION */

    /* THINGS TO INITIALIZE ONCE */

    // The decoder in which this service operates
    DECODER_OBJECT hDecoder;

    // The currently set Market ID
    CID_OBJECT hMarketID;

    // Events Callback handler
    TW_NOW_EVENT_CALLBACK vEventCallback;
    void *pvEventCallbackArg;

    // TW Now Tag Handle
    TAG_OBJECT hTag;

    /* THINGS TO RE-INITIALIZE ON DEMAND or RESET */
    TW_NOW_BULLETIN_ID tAvailableBulletinID;
    TW_NOW_BULLETIN_ID tCurrentBulletinID;

} TW_NOW_OBJECT_STRUCT;

// This structure is used to handle TW Now Bulletin Event data
typedef struct tw_now_bulletin_event_struct
{
    CHANNEL_ID tChannelID;
    TW_NOW_BULLETIN_ID tBulletinID;

} TW_NOW_BULLETIN_EVENT_STRUCT;

typedef struct tw_now_market_iterator_struct
{
    BOOLEAN bFound;
    CID_OBJECT hMarketID;
} TW_NOW_MARKET_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eStart (
    DECODER_OBJECT hDecoder,
    TW_NOW_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

static void vStop (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eSetMarketID (
    DECODER_OBJECT hDecoder,
    CID_OBJECT hMarketID
        );

static CID_OBJECT hGetMarketID (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM ePlayBulletinAudio (
    DECODER_OBJECT hDecoder,
    TW_NOW_BULLETIN_ID tBulletinID
        );

static SMSAPI_RETURN_CODE_ENUM eAbortBulletinPlayback (
    DECODER_OBJECT hDecoder
        );

static TW_NOW_BULLETIN_ID tCurrentBulletinID (
    DECODER_OBJECT hDecoder
        );

/* Object Private Prototypes */

static BOOLEAN bHandleSetMarketIDEvent (
    TW_NOW_OBJECT_STRUCT *psObj,
    TRAFFIC_MARKET tMarketID
        );

static BOOLEAN bHandleStopEvent(
    TW_NOW_OBJECT_STRUCT *psObj
        );

static SMSAPI_RETURN_CODE_ENUM eCreateTWNow (
    DECODER_OBJECT hDecoder,
    UN8 *pun8MarketID,
    TW_NOW_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

static void vDestroyTWNow (
    TW_NOW_OBJECT_STRUCT *psObj
        );

static BOOLEAN bCreateTag (
    TW_NOW_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRestoreTWNow (
    TW_NOW_OBJECT_STRUCT *psObj
        );

static BOOLEAN bSaveTWNow (
    TW_NOW_OBJECT_STRUCT *psObj
        );

static BOOLEAN bMarketIterator(
    const char *pacId,
    const char *pacName,
    CID_OBJECT hId,
    void *pvContentIteratorCallbackArg
        );

/***************/
/** VARIABLES **/
/***************/

// Sports Flash Object Defaults
static const TW_NOW_OBJECT_STRUCT gsObjectDefaults =
{
    /* THINGS PROVIDED BY APPLICATION */

    /* THINGS TO INITIALIZE ONCE */

    // The decoder in which this service operates
    DECODER_INVALID_OBJECT,

    // Market
    CID_INVALID_OBJECT,

    // Events Callback handler
    NULL,
    NULL,

    // TW Now Tag handle
    TAG_INVALID_OBJECT,

    /* THINGS TO RE-INITIALIZE ON DEMAND or RESET */
    TW_NOW_INVALID_BULLETIN_ID,
    TW_NOW_INVALID_BULLETIN_ID

};

// Global instance of an interface for this object
const TW_NOW_OBJECT_INTERFACE_STRUCT TW_NOW =
{
    /*.eStart = */eStart,
    /*.vStop = */vStop,
    /*.eSetMarketID = */eSetMarketID,
    /*.hGetMarketID = */hGetMarketID,
    /*.ePlayBulletinAudio = */ePlayBulletinAudio,
    /*.eAbortBulletinPlayback = */eAbortBulletinPlayback,
    /*.tCurrentBulletinID = */tCurrentBulletinID
};

/**********************/
/** INLINE FUNCTIONS **/
/**********************/

#endif /* _TWN_OBJ_H_ */
