/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _TRAFFIC_LOCID_OBJ_H_
#define _TRAFFIC_LOCID_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define TRAFFIC_LOCID_OBJECT_NAME "TRAFFIC_LOCID"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum traffic_locid_compare_style_enum
{
    TRAFFIC_LOCID_COMPARE_STYLE_FULL = 0,
    TRAFFIC_LOCID_COMPARE_STYLE_MARKET,
    TRAFFIC_LOCID_COMPARE_STYLE_BSA
} TRAFFIC_LOCID_COMPARE_STYLE_ENUM;

/* Private object elements */


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static TRAFFIC_LOCID_OBJECT hCreate (
    TRAFFIC_POS_CODE tPosCode,
    TRAFFIC_MARKET tMarket,
    TRAFFIC_BSA tBSA
        );

static TRAFFIC_LOCID_OBJECT hCreateExt (
    TRAFFIC_POS_CODE tPosCode,
    TRAFFIC_MARKET tMarket,
    TRAFFIC_BSA tBSA,
    TRAFFIC_OFFSET tOffset
        );

static TRAFFIC_POS_CODE tPosCode (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

static TRAFFIC_MARKET tMarket (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

static TRAFFIC_BSA tBSA (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

static TRAFFIC_OFFSET tOffset (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

static TRAFFIC_LOCID_TYPE_ENUM eType (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

static N16 n16CompareMarkets (
    TRAFFIC_LOCID_OBJECT hTrafficLocID1,
    TRAFFIC_LOCID_OBJECT hTrafficLocID2
        );

static N16 n16CompareBSAs (
    TRAFFIC_LOCID_OBJECT hTrafficLocID1,
    TRAFFIC_LOCID_OBJECT hTrafficLocID2
        );

static TRAFFIC_LOCID_OBJECT hFRead (
    FILE *psFile
        );

static void vDestroy (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

/* Object Private Prototypes */

static TRAFFIC_LOCID_OBJECT hDuplicate (
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );

COMPILE_TIME_ASSERT(sizeof(UN8) == sizeof(TRAFFIC_MARKET),
    TRAFFIC_LOCID_n32FWrite_Wrong_Traffic_Market_Size);
COMPILE_TIME_ASSERT(sizeof(UN32) == sizeof(TRAFFIC_BSA),
    TRAFFIC_LOCID_n32FWrite_Wrong_Traffic_BSA_Size);
static N32 n32FWrite (
    TRAFFIC_LOCID_OBJECT hTrafficLocID,
    FILE *psFile
        );

static N16 n16Compare (
    TRAFFIC_LOCID_OBJECT hTrafficLocID1,
    TRAFFIC_LOCID_OBJECT hTrafficLocID2
        );

static N32 n32FPrintf (
    TRAFFIC_LOCID_OBJECT hTrafficLocID,
    FILE *psFile
        );

static N16 n16CompareTrafficLocIDs (
    TRAFFIC_LOCID_OBJECT hTrafficLocID1,
    TRAFFIC_LOCID_OBJECT hTrafficLocID2,
    TRAFFIC_LOCID_COMPARE_STYLE_ENUM eCompareStyle
        );


  /***************/
 /** VARIABLES **/
/***************/

// Global  inteface for the TRAFFIC_LOCID object
static const LOCID_INTERFACE_STRUCT gsTrafficLocIDInterface =
{
    /*.hDuplicate = */(const void * (*)( const void *))hDuplicate,
    /*.n16Compare = */(N16 (*)(const void *, const void *))n16Compare,
    /*.n32FWrite = */(N32 (*)(const void *, FILE *))n32FWrite,
    /*.n32FPrintf = */(N32 (*)(const void *, FILE *))n32FPrintf
};

// Global (re-usable) instance of an interface for this object
const TRAFFIC_LOCID_OBJECT_INTERFACE_STRUCT TRAFFIC_LOCID =
{
    /*.hCreate = */hCreate,
    /*.hCreateExt = */hCreateExt,
    /*.tPosCode = */tPosCode,
    /*.tMarket = */tMarket,
    /*.tBSA = */tBSA,
    /*.tOffset = */tOffset,
    /*.eType = */eType,
    /*.n16CompareMarkets = */n16CompareMarkets,
    /*.n16CompareBSAs = */n16CompareBSAs,
    /*.hFRead = */hFRead,
    /*.vDestroy = */vDestroy
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _TRAFFIC_LOCID_OBJ_H_
