/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _THEATER_OBJ_H_
#define _THEATER_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "theater_times_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define THEATER_OBJECT_NAME "THEATER"

#define THEATER_BASE_AMENITY (THEATER_AMENITY_STADIUM_SEATING)
#define THEATER_MAX_AMENITY (THEATER_AMENITY_STADIUM_ROCKER_SEATING)
#define THEATER_AMENITY_BITMASK (0x3)
#define THEATER_AMENITY_AVAILABLE (1)
#define THEATER_AMENITY_SECONDARY_AVAILABLE (2)
#define THEATER_AMENITY_NOT_AVAILABLE (3)

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */
typedef struct theater_object_struct
{
    LOCATION_OBJECT hLocation;

    THEATER_TIMES_OBJECT hShowTimes;

    UN16 un16Amenities;

} THEATER_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static LOCATION_OBJECT hLocation (
    THEATER_OBJECT hTheater
        );

static UN8 un8NumMovies (
    THEATER_OBJECT hTheater
        );

static SMSAPI_RETURN_CODE_ENUM eIterateMovies (
    THEATER_OBJECT hTheater,
    THEATER_MOVIES_ITERATOR bIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM  eIterateTimes (
    THEATER_OBJECT hTheater,
    THEATER_MOVIE_TIMES_ITERATOR bIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eAmenities (
    THEATER_OBJECT hTheater,
    size_t tNumAmenities,
    AMENITY_STRUCT *pasTheaterAmenities
        );

static N32 n32FPrintf (
    THEATER_OBJECT hTheater,
    FILE *psFile
        );

/* Object Private Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const THEATER_OBJECT_INTERFACE_STRUCT THEATER =
{
    /*.hLocation = */hLocation,
    /*.un8NumMovies = */un8NumMovies,
    /*.eIterateMovies = */eIterateMovies,
    /*.eIterateTimes = */eIterateTimes,
    /*.eAmenities = */eAmenities,
    /*.n32FPrintf = */n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _THEATER_OBJ_H_
