/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _TEMPERATURE_OBJ_H_
#define _TEMPERATURE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define TEMPERATURE_OBJECT_NAME "TEMPERATURE"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct temperature_object_struct
{
	BOOLEAN bHighAvailable;
	BOOLEAN bLowAvailable;
	BOOLEAN bCurAvailable;
	N16 n16High;
	N16 n16Low;
	N16 n16Current;
} TEMPERATURE_OBJECT_STRUCT;


//Prototypes
static SMSAPI_RETURN_CODE_ENUM eHigh (
	TEMPERATURE_OBJECT hTemperature,
	N16 *n16HighTemperature
		);

static SMSAPI_RETURN_CODE_ENUM eLow (
	TEMPERATURE_OBJECT hTemperature,
	N16 *n16LowTemperature
		);

static SMSAPI_RETURN_CODE_ENUM eCurrent (
	TEMPERATURE_OBJECT hTemperature,
	N16 *n16CurrentTemperature
		);

static N32 n32FPrintf (
	TEMPERATURE_OBJECT hTemperature,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const TEMPERATURE_OBJECT_INTERFACE_STRUCT TEMPERATURE =
{
	/*.eHigh = */eHigh,
	/*.eLow = */eLow,
	/*.eCurrent = */eCurrent,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _TEMPERATURE_OBJ_H_ */
