/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _STOCK_MSG_OBJ_H_
#define _STOCK_MSG_OBJ_H_

/**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <string.h>

#include "standard.h"
#include "osal.h"
#include "sms_api.h"
#include "dsrl_entry_obj.h"
#include "string_obj.h"

#include "stock_ticker_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define STOCK_MSG_OBJECT_NAME "STOCK_MSG"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct stock_msg_object_struct
{
    // Symbol index
    STOCK_ID tIndex;

    // Symbol name
    STRING_OBJECT hSymbolName;

    // Value state (valid, invalid, delisted or NA)
    STOCK_MSG_STATE_ENUM eState;

    // Corresponded target
    STOCK_SYMBOL_OBJECT hStockSymbol;

    // Values
    STOCK_TICKER_QUOTE_STRUCT sQuote;
} STOCK_MSG_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hSymbolName (
    STOCK_MSG_OBJECT hMsg
       );

static SMSAPI_RETURN_CODE_ENUM eValues (
    STOCK_MSG_OBJECT hMsg,
    UN32 *pun32Price,
    UN8 *pun8PriceFrac,
    UN32 *pun32PriceDelta,
    UN8 *pun8PriceDeltaFrac,
    STOCK_MSG_PRICE_DIRECTION_ENUM *peDirection
       );

static STOCK_SYMBOL_OBJECT hStockSymbol (
    STOCK_MSG_OBJECT hMsg
        );

static N32 n32FPrintf (
    STOCK_MSG_OBJECT hMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
       );

static STOCK_TICKER_RETURN_CODE_ENUM eCreateObject(
    STOCK_MSG_OBJECT_STRUCT **ppsObj,
    SMS_OBJECT hParent,
    size_t tDescriptorSize,
    STOCK_ID tIndex
        );

static void vDestroyObject(
    STOCK_MSG_OBJECT_STRUCT *psObj
        );

static STOCK_TICKER_RETURN_CODE_ENUM eUpdateData (
    STOCK_MSG_OBJECT_STRUCT *psObj,
    STOCK_MSG_DATA_STRUCT *psData
        );

static STOCK_TICKER_RETURN_CODE_ENUM eUpdateIndex(
    STOCK_MSG_OBJECT_STRUCT *psObj,
    STOCK_ID tIndex
        );

static STOCK_TICKER_RETURN_CODE_ENUM eUpdateName(
    STOCK_MSG_OBJECT_STRUCT *psObj,
    STRING_OBJECT hNewName
        );

static STOCK_TICKER_RETURN_CODE_ENUM eUpdateNameCStr(
    STOCK_MSG_OBJECT_STRUCT *psObj,
    const char *pacName,
    size_t tNameLength
        );

static STOCK_TICKER_RETURN_CODE_ENUM eUpdateValues(
    STOCK_MSG_OBJECT_STRUCT *psObj,
    STOCK_MSG_STATE_ENUM eState,
    const STOCK_TICKER_QUOTE_STRUCT *psQuote
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const STOCK_MSG_INTERFACE_STRUCT STOCK_MSG = {
    /*.hSymbolName = */  hSymbolName,
    /*.eValues = */      eValues,
    /*.hStockSymbol = */ hStockSymbol,
    /*.n32FPrintf = */   n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/


#endif /* _STOCK_MSG_OBJ_H_ */
