/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SPORTS_MONITOR_OBJ_H_
#define _SPORTS_MONITOR_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SPORTS_MONITOR_OBJECT_NAME "SportsMonitor"

  /**************/
 /** TYPEDEFS **/
/**************/

//  The main sports monitor structure
typedef struct sports_monitor_object_struct
{
    SPORTS_MONITOR_CALLBACK vCallback;
    void *pvCallbackArg;
    SPORTS_SERVICE_OBJECT hSportsService;

    SPORTS_MONITOR_EVENT_MASK tUserMask;
    SPORTS_MONITOR_EVENT_MASK tEventBits;

    OSAL_OBJECT_HDL hAffiliateList;
} SPORTS_MONITOR_OBJECT_STRUCT;

// Structure used in the affiliate list.
typedef struct affiliate_monitor_struct
{
    AFFILIATE_ID tAffiliateId;
    SPORTS_MONITOR_EVENT_MASK tUserMask;
    SPORTS_MONITOR_EVENT_MASK tEventBits;
} AFFILIATE_MONITOR_STRUCT;

// Structure used to iterate the affiliate list.
typedef struct affiliate_iterator_struct
{
    SPORTS_MONITOR_OBJECT_STRUCT *psMonObj;
    SPORT_MONITOR_ITERATOR bIterator;
    void *pvIteratorArg;

} AFFILIATE_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SPORTS_MONITOR_OBJECT hCreate (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_CALLBACK vCallback,
    void *pvCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eGetEventMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

static SMSAPI_RETURN_CODE_ENUM eSetEventMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

static void vDestroy (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor
        );

static SMSAPI_RETURN_CODE_ENUM eSetAffiliateMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

static SMSAPI_RETURN_CODE_ENUM eGetAffiliateMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

static SMSAPI_RETURN_CODE_ENUM eRemoveAllAffiliates (
    SPORTS_MONITOR_OBJECT hMonitor
        );

static SMSAPI_RETURN_CODE_ENUM eIterateChangedAffiliates (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORT_MONITOR_ITERATOR bIterator,
    void *pvIteratorArg
        );

/* Object Private Prototypes */
static N16 n16FindByAffiliateId (
    AFFILIATE_MONITOR_STRUCT *psAffiliateMonitor,
    AFFILIATE_ID *ptDesiredAffiliateId
        );

static BOOLEAN bIterateChangedAffiliatesHandler (
    AFFILIATE_MONITOR_STRUCT *psAffiliateMonitor,
    void *pvArg
        );

/* Object Inline Prototypes */
__INLINE__ void vAffiliateMonitorInitialize (
    AFFILIATE_MONITOR_STRUCT *psAffiliateMonitor,
    AFFILIATE_ID tAffiliateId,
    SPORTS_MONITOR_EVENT_MASK tUserMask
    );

// Global instance of an interface for this object
const SPORTS_MONITOR_INTERFACE_STRUCT SPORTS_MONITOR =
{
    /*.hCreate = */hCreate,
    /*.eGetEventMask = */eGetEventMask,
    /*.eSetEventMask = */eSetEventMask,
    /*.vDestroy = */vDestroy,
    /*.eSetAffiliate = */eSetAffiliateMask,
    /*.eGetAffiliateMask = */eGetAffiliateMask,
    /*.eRemoveAllAffiliates = */eRemoveAllAffiliates,
    /*.eIterateChangedAffiliates = */eIterateChangedAffiliates,
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
__INLINE__ void vAffiliateMonitorInitialize (
    AFFILIATE_MONITOR_STRUCT *psAffiliateMonitor,
    AFFILIATE_ID tAffiliateId,
    SPORTS_MONITOR_EVENT_MASK tUserMask
    )
{
    psAffiliateMonitor->tAffiliateId = tAffiliateId;
    psAffiliateMonitor->tUserMask = tUserMask;
    psAffiliateMonitor->tEventBits = 0;
    return;
}

#endif /* _SPORTS_MONITOR_OBJ_H_ */
