/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SPORT_ZONE private header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SPORT_ZONE_H_
#define _SPORT_ZONE_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SPORT_ZONE_OBJECT_NAME "SPORT_ZONE"

#define SPORT_ZONE_LONG_CAT_NAME_PREFIX "My "
#define SPORT_ZONE_LONG_CAT_NAME_SUFFIX " Zone"

#define SPORT_ZONE_CAL_AUTO_ADD_OPTIONS \
         ( CAL_AUTO_ADD_OPTION_IF_TUNED  | \
           CAL_AUTO_ADD_OPTION_IF_NOT_TUNED  | \
           CAL_AUTO_ADD_OPTION_UNIQUE | \
           CAL_AUTO_ADD_OPTION_TOP  )

  /**************/
 /** TYPEDEFS **/
/**************/

//  The SPORT_ZONE_SERVICE structure
typedef struct sport_zone_service_object_struct
{
    // The LL used to store the spors zones as they are created
    OSAL_OBJECT_HDL hZoneList;

} SPORT_ZONE_SERVICE_OBJECT_STRUCT;

//  The SPORT_ZONE structure
typedef struct sport_zone_object_struct
{
    // The CAL used to monitor soprs content and manage the category
    CAL_OBJECT hCAL;

    // the league associated with this zone
    LEAGUE_OBJECT hLeague;

} SPORT_ZONE_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static SMSAPI_RETURN_CODE_ENUM eStart (
    DECODER_OBJECT hDecoder
        );

static void vStop (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eIterate (
    DECODER_OBJECT hDecoder,
    SPORT_ZONE_ITERATION_HANDLER bIterator,
    void *pvArg
        );

static SPORT_ZONE_OBJECT hCreate(
    DECODER_OBJECT hDecoder,
    LEAGUE_OBJECT hLeague
      );

static void vDestroy(
    SPORT_ZONE_OBJECT hSportZone
        );

static CATEGORY_ID tCategoryId(
    SPORT_ZONE_OBJECT hSportZone
        );

static LEAGUE_OBJECT hLeague(
    SPORT_ZONE_OBJECT hSportZone
        );

static N16 n16FindZoneByLeague(
    void *pvArg1,
    void *pvArg2
        );

static SMSAPI_RETURN_CODE_ENUM eAddToZoneList(
    DECODER_OBJECT hDecoder,
    SPORT_ZONE_OBJECT hSportZone
        );

static void vRemove(
    DECODER_OBJECT hDecoder,
    LEAGUE_OBJECT hLeague
        );

static OSAL_LINKED_LIST_ENTRY hFindInZoneList(
    DECODER_OBJECT hDecoder,
    LEAGUE_OBJECT hLeague
        );

static void vCALCallback(
    CAL_OBJECT hCAL,
    CAL_ALERT_OBJECT hAlert,
    UN32 un32Flags,
    void *pvCALCallbackArg
        );

static void vDestroyZone(
    SPORT_ZONE_OBJECT hSportZone
        );

  /***************/
 /** VARIABLES **/
/***************/


// Global instance of an interface for this object
const SPORT_ZONE_OBJECT_INTERFACE_STRUCT SPORT_ZONE =
{
    /*.eStart = */eStart,
    /*.vStop = */vStop,
    /*.eIterate = */eIterate,
    /*.hCreate = */hCreate,
    /*.vDestroy = */vDestroy,
    /*.tCategoryId = */tCategoryId,
    /*.hLeague = */hLeague,
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif
