/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SP_SEEK_CONTENT_H
#define _SP_SEEK_CONTENT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "seek_content.h"
#include "sp_seek_content.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define SP_SEEK_CONTENT_OBJECT_NAME "SP_SEEK_CONTENT"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hRegisteredName (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static STRING_OBJECT hRegisteredNickname (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static CID_OBJECT hRegisteredLeagueId (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static CID_OBJECT hRegisteredTeamId (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static SP_SEEK_ENUM eType (
    SEEK_CONTENT_OBJECT hSeekContent
        );

/* Object Private Prototypes */

static N32 n32FPrintf (
    void *pvServiceSpecific,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static void vUnInit(
    void *pvServiceSpecific
        );

static BOOLEAN bSearchForCurrentAfterEnable (
    void *pvServiceSpecific
        );

  /***************/
 /** VARIABLES **/
/***************/

// service specific content interface for the A/T Seek Service
const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsSPSeekContent =
{
    /*.vUnInit = */vUnInit,
    /*.n32FPrintf = */n32FPrintf,
    /*.bSearchForCurrentAfterEnable = */bSearchForCurrentAfterEnable
};

// Global instance of an interface for this object
const SP_SEEK_CONTENT_INTERFACE_STRUCT SP_SEEK_CONTENT =
{
    /*.hRegisteredName = */hRegisteredName,
    /*.hRegisteredNickname = */hRegisteredNickname,
    /*.hRegisteredLeagueId = */hRegisteredLeagueId,
    /*.hRegisteredTeamId = */hRegisteredTeamId,
    /*.eType = */eType
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SP_SEEK_CONTENT_H
