/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SONG_TAG_SERVICE_H_
#define _SONG_TAG_SERVICE_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SONG_TAG_SERVICE_NAME "SONG_TAG_SRV"
#define SONG_TAG_URL_NAME "SONG_TAG_URL"

#define SONG_TAG_URL
  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */


typedef struct song_tag_mapping_struct
{
    STRING_OBJECT hInstance;
    SONG_TAG_SERVICE_ENUM eService;

}SONG_TAG_MAPPING_STUCT;

typedef struct song_tag_service_struct
{
    STRING_OBJECT hITunesURL;
    TAG_OBJECT hTag;

}SONG_TAG_SERVICE_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static STRING_OBJECT hURL (
    SONG_TAG_SERVICE_ENUM eService
        );

static BOOLEAN bIterate (
    SONG_TAG_SERVICE_ITERATOR_CALLBACK bIteratorCallback,
    void *pvContentIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eGetITunesTagValue (
    CID_OBJECT hTag,
    UN32 *pun32TagValue
        );

static CID_OBJECT hCreateITunesTag (
    UN32 un32ITunesTagValue
        );

/* Object Private Prototypes */

static BOOLEAN bGetURL(
    SONG_TAG_SERVICE_STRUCT *psStruct,
    SONG_TAG_SERVICE_ENUM eService,
    STRING_OBJECT **pphURL
        );

static BOOLEAN bMapping(
    SONG_TAG_SERVICE_ENUM eService,
    STRING_OBJECT hURL,
    void *pvIteratorArg
        );

static BOOLEAN bRestoreServiceIterator(
    TAG_OBJECT hTag,
    void *pvArg
        );

static BOOLEAN bSaveToConfig(
    SONG_TAG_SERVICE_ENUM eService,
    TAG_OBJECT hParentTag,
    STRING_OBJECT hNewURL
        );

static BOOLEAN bRestoreFromConfig(
    TAG_OBJECT hParentTag,
    SONG_TAG_SERVICE_STRUCT *psStruct
        );

static void vIterateServices(
    SONG_TAG_SERVICE_STRUCT *psStruct,
    SONG_TAG_SERVICE_ITERATOR_CALLBACK bIteratorCallback,
    void *pvContentIteratorArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const SONG_TAG_SERVICE_INTERFACE_STRUCT SONG_TAG_SERVICE =
{
    /*.hURL = */hURL,
    /*.bIterate = */bIterate,
    /*.eGetITunesTagValue = */eGetITunesTagValue,
    /*.hCreateITunesTag = */hCreateITunesTag
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SONG_TAG_SERVICE_H_
