/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SNOW_CONDITIONS_OBJ_H_
#define _SNOW_CONDITIONS_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SNOW_CONDITIONS_OBJECT_NAME "SNOW_CONDITIONS"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct snow_conditions_object_struct
{
	BOOLEAN bBMinAvailable;
	UN8 un8BMin;
	BOOLEAN bBMaxAvailable;
	UN8 un8BMax;
	BOOLEAN bNewAvailable;
	NEW_SNOW_DATA_STRUCT sNewData;
	BOOLEAN bSnowAvailable;
	UN8 un8Snow;
} SNOW_CONDITIONS_OBJECT_STRUCT;


//Prototypes
static SMSAPI_RETURN_CODE_ENUM eMinBaseDepth (
	SNOW_CONDITIONS_OBJECT hSnowCond,
	UN8 *pun8MinBaseDepth
		);

static SMSAPI_RETURN_CODE_ENUM eMaxBaseDepth (
	SNOW_CONDITIONS_OBJECT hSnowCond,
	UN8 *pun8MaxBaseDepth
		);

static SMSAPI_RETURN_CODE_ENUM eNewSnowRange (
	SNOW_CONDITIONS_OBJECT hSnowCond,
	UN8 *pun8NewSnowRangeLow,
	UN8 *pun8NewSnowRangeHigh
		);

static SMSAPI_RETURN_CODE_ENUM eConditions (
	SNOW_CONDITIONS_OBJECT hSnowCond,
	SKI_SNOW_CONDITIONS_ENUM *peConditions
		);

static N32 n32FPrintf (
	SNOW_CONDITIONS_OBJECT hSnowCond,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const SNOW_CONDITIONS_OBJECT_INTERFACE_STRUCT SNOW_CONDITIONS =
{
	/*.eMinBaseDepth = */eMinBaseDepth,
	/*.eMaxBaseDepth = */eMaxBaseDepth,
	/*.eNewSnowRange = */eNewSnowRange,
	/*.eConditions = */eConditions,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _SNOW_CONDITIONS_OBJ_H_ */
