/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SMS_TASK_H_
#define _SMS_TASK_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "sms_event.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define SMS_TASK_NAME "SMST"

  /**************/
 /** TYPEDEFS **/
/**************/

/*
    SMS Task Control Structure
*/

typedef struct sms_task_control_struct
{
    // Install Complete Semaphore
    OSAL_OBJECT_HDL hInstallSemaphore;

    // Task Name
    char acName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];

    // Task reporting interval and timeout parameters
    UN16 un16ReportingInterval;
    UN16 un16Timeout;

    // Task Handle and Debug info
    OSAL_OBJECT_HDL hTask;

    // Event Handler & Queue Info
    SMS_EVENT_HANDLER *phEventHdlr;
    UN32 un32EventQueueSize;
    SMS_OBJECT_EVENT_HANDLER_PROTOTYPE vEventHandler;
    UN32 un32EventHandlerOptions;

    SMS_OBJECT hSMS;

} SMS_TASK_CONTROL_STRUCT; // (SMS_TASK_HANDLE)

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N32 SMST_n32Task ( void *pvArg );
static BOOLEAN SMST_bInitialize( void *pvArg );
static void SMST_vUninitialize( void *pvArg );
static void SMST_vSleepHandler( void *pvArg );
static void SMST_vWakeupHandler( void *pvArg );
static void SMST_vShutdownHandler( void *pvArg );

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _SMS_TASK_H_
