/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SMS_OBJ_H_
#define _SMS_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// set to 1 if you wish to test Lock/Ownership traps
// while debugging SMS
#define SMS_OBJECT_TRAP_VIOLATIONS 0

/* Object name prefix for objects */
#define SMS_OBJECT_NAME "SMS"

// Just take the inverse of the value provided
#define SMS_OBJECT_MAGIC_NUMBER(x) (~((size_t)(x)))

// Compute Magic Number and test
#define SMS_OBJECT_MAGIC_NUMBER_OK(x) ((~(((x)->tMagicNumber) \
        ^ ((size_t)x))) == 0)

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct sms_object_struct
{
    // Physical mutex (populated if this is is a parent object with the
    // lock feature enable)
    OSAL_OBJECT_HDL hMutex;

    // Physical Mutex Owner (id of task currently owning the resource)
    OSAL_TASK_ID tMutexOwner;
    // Lock indicator (TRUE if locked)
    BOOLEAN bLocked;
    // Pointer to the Mutex Owner (a task id)
    OSAL_TASK_ID *ptMutexOwner;
    // Pointer to Lock indicator
    BOOLEAN *pbLocked;

    // Owner lock count
    size_t tOwnerLockCount;

    // Pointer to the owner lock count
    size_t *ptOwnerLockCount;

    // Child count
    size_t tChildCount;

    // Parent object (if any)
    SMS_OBJECT hParent;

    // SMS Object Magic Number
    // Just a number to "reasonably" ensure this is really an SMS object
    size_t tMagicNumber;

} SMS_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static BOOLEAN bValid (
    SMS_OBJECT hSMS,
    BOOLEAN bEnforce
        );

static BOOLEAN bOwner (
    SMS_OBJECT hSMS,
    BOOLEAN bEnforce
        );

static void vHandleFatalError ( void );

  /***************/
 /** VARIABLES **/
/***************/

// Fatal error couunter
size_t gtSMSObjectFatalErrorCounter = 0;

// Dummy initializer object
const SMS_OBJECT_STRUCT gsInitObj =
{
    OSAL_INVALID_OBJECT_HDL,
    (OSAL_TASK_ID)0,
    FALSE,
    (OSAL_TASK_ID *)NULL,
    (BOOLEAN *)NULL,
    0,
    (size_t *)NULL,
    0,
    SMS_INVALID_OBJECT,
    0
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SMS_OBJ_H_
