/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SMART_FAVORITES_OBJ_H_
#define _SMART_FAVORITES_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "tag_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SMART_FAVORITES_OBJECT_NAME "SMART_FAVORITES"

// Smart Favorites category names

/* Long Name */
#define SMART_FAVORITES_CATEGORY_LONG_NAME "Smart Favorites Service"
/* Short Name */
#define SMART_FAVORITES_CATEGORY_SHORT_NAME "Smart Favorites"

// Smart Favorites Tag definitions

/* Smart Favorites Play Point Ctrl Tag Name */
#define SMART_FAVORITES_PLAY_POINT_CTRL_TAG_NAME "PlayPoint"
/* Smart Favorites Enabled Tag Name */
#define SMART_FAVORITES_ENABLED_TAG_NAME "Enabled"

#define SMART_FAVORITES_MAX_ID_LENGTH       3
#define SMART_FAVORITES_MAX_POS_LENGTH      16
#define SMART_FAVORITES_MAX_CCT_LENGTH      13
#define SMART_FAVORITES_MAX_NAME_LENGTH     20

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct smart_favorites_object_struct
{
    /* THINGS PROVIDED BY APPLICATION */

    /* THINGS TO INITIALIZE ONCE */

    // The decoder in which this service operates
    DECODER_OBJECT hDecoder;

    // Smart Favorites Category Id
    CATEGORY_ID tCategoryId;

    // Smart favorites Tag Handle
    TAG_OBJECT hTag;

    /* THINGS TO RE-INITIALIZE ON DEMAND or RESET */

    // Smart Favorites Status
    BOOLEAN bEnabled;

    // Play Point Ctrl
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM ePlayPoint;

    // Current Preset Band Tracking
    BOOLEAN bCurrentBand;

} SMART_FAVORITES_OBJECT_STRUCT;

// Smart Favorites print struct
typedef struct smart_favorites_print_struct
{
    // How many chars are printed
    N32 *pn32Chars;

    // File to print to
    FILE *psFile;

    // How many channels we have
    size_t tSize;

} SMART_FAVORITES_PRINT_STRUCT;

// Smart Favorites Iteartor Struct
typedef struct smart_favorites_iterator_struct
{
    // How many channels we have
    UN16 un16Size;

    // Current array size
    UN16 un16ArraySize;

    // Pointer to array of Smart Candidates
    SERVICE_ID *ptServiceId;

} SMART_FAVORITES_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eStart (
    DECODER_OBJECT hDecoder,
    BOOLEAN bCurrentBand
        );

static void vStop (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eEnable (
    DECODER_OBJECT hDecoder,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM ePlayPoint
        );

static SMSAPI_RETURN_CODE_ENUM eDisable (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eGetCurrentConfig (
    DECODER_OBJECT hDecoder,
    BOOLEAN *pbEnabled,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM *pePlayPoint
        );

static CATEGORY_ID tCategoryId (
    DECODER_OBJECT hDecoder
        );

static N32 n32FPrintf (
    DECODER_OBJECT hDecoder,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOptions
        );

/* Object Private Prototypes */

static void vCategoryEventCallback (
    CATEGORY_OBJECT hCategory,
    CATEGORY_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eCreateSmartFavorites (
    DECODER_OBJECT hDecoder,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM *pePlayPoint,
    BOOLEAN *pbEnabled,
    BOOLEAN bCurrentBand
        );

static BOOLEAN bCreateTag (
    SMART_FAVORITES_OBJECT_STRUCT *psObj
        );

static BOOLEAN bDisableSmartFavorites (
    DECODER_OBJECT hDecoder
        );

static BOOLEAN bEnableSmartFavorites (
    DECODER_OBJECT hDecoder,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM ePlayPoint
        );

static N16 n16PrintChannelsTerse (
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static N16 n16PrintChannelsVerbose (
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static N16 n16PrintChannelsGross (
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static BOOLEAN bRegisterCategory (
    SMART_FAVORITES_OBJECT_STRUCT *psObj
        );

static void vRemoveCategory (
    SMART_FAVORITES_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRestoreSmartFavorites (
    SMART_FAVORITES_OBJECT_STRUCT *psObj,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM *pePlayPoint,
    BOOLEAN *pbEnabled
        );

static BOOLEAN bSaveState (
    TAG_OBJECT hParentTag,
    BOOLEAN bEnabled
        );

static BOOLEAN bSavePlayPoint (
    TAG_OBJECT hParentTag,
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM ePlayPoint
        );

static BOOLEAN bStartSmartFavorites (
    SMART_FAVORITES_OBJECT_STRUCT *psObj
        );

static N16 n16StartIterator (
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static N16 n16UpdateIterator (
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static BOOLEAN bUpdateSmartFavorites (
    SMART_FAVORITES_OBJECT_STRUCT *psObj
        );

static char *pacPlayPoint (
    SMART_FAVORITES_PLAY_POINT_CTRL_ENUM ePlayPointCtrl
        );

static void vChannelEventCallback (
    CHANNEL_OBJECT hChannel,
    CHANNEL_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Smart Favorites Object Defaults
static const SMART_FAVORITES_OBJECT_STRUCT gsObjectDefaults =
{
    /* THINGS PROVIDED BY APPLICATION */

    /* THINGS TO INITIALIZE ONCE */

    // The decoder in which this service operates
    DECODER_INVALID_OBJECT,

    // Smart Favorites Category Id
    CATEGORY_INVALID_ID,

    // Smart Favorites Tag Handle
    TAG_INVALID_OBJECT,

    /* THINGS TO RE-INITIALIZE ON DEMAND or RESET */

    // Smart Favorites Status
    FALSE,

    // Play Point Ctrl
    SMART_FAVORITES_PLAY_POINT_CTRL_START,

    // Current Preset Band Tracking
    FALSE
};

// Global (re-usable) instance of an interface for this object
const SMART_FAVORITES_OBJECT_INTERFACE_STRUCT SMART_FAVORITES =
{
    /*.eStart = */eStart,
    /*.vStop = */vStop,
    /*.eEnable = */eEnable,
    /*.eDisable = */eDisable,
    /*.eGetCurrentConfig = */eGetCurrentConfig,
    /*.tCategoryId = */tCategoryId,
    /*.n32FPrintf = */n32FPrintf

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _SMART_FAVORITES_OBJ_H_
