/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SKI_CONDITIONS_OBJ_H_
#define _SKI_CONDITIONS_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SKI_CONDITIONS_OBJECT_NAME "SKI_CONDITIONS"

  /**************/
 /** TYPEDEFS **/
/**************/

// Private object structure
typedef struct ski_conditions_object_struct
{
	SKI_DATA_STRUCT sData;
	WEATHER_EVENT_OBJECT hWeatherEvent;
	TEMPERATURE_OBJECT hTemperature;
	SNOW_CONDITIONS_OBJECT hSnow;
	SKI_ATTRIBUTES_OBJECT hAttributes;
	UN32 un32TimeStamp;
} SKI_CONDITIONS_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eOperationalStatus (
    SKI_CONDITIONS_OBJECT hSkiCond,
    BOOLEAN *pbOperStatus
        );

static SMSAPI_RETURN_CODE_ENUM eWeatherEvent (
	SKI_CONDITIONS_OBJECT hSkiCond,
	WEATHER_EVENT_OBJECT *phWeatherEvent
        );

static SMSAPI_RETURN_CODE_ENUM eTemperature (
	SKI_CONDITIONS_OBJECT hSkiCond,
	TEMPERATURE_OBJECT *phTemperature
        );

static SMSAPI_RETURN_CODE_ENUM eWindCondition (
	SKI_CONDITIONS_OBJECT hSkiCond,
	SKI_WIND_CONDITION_ENUM *peWindCond
        );

static SMSAPI_RETURN_CODE_ENUM eSnowConditions (
	SKI_CONDITIONS_OBJECT hSkiCond,
	SNOW_CONDITIONS_OBJECT *phSnowCond
        );

static SMSAPI_RETURN_CODE_ENUM eAttributes (
	SKI_CONDITIONS_OBJECT hSkiCond,
	SKI_ATTRIBUTES_OBJECT *phSkiAttributes
        );

static UN32 un32TimeStamp (
	SKI_CONDITIONS_OBJECT hSkiCond
        );

static N32 n32FPrintf (
	SKI_CONDITIONS_OBJECT hSkiCond,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static void vDestroy(SKI_CONDITIONS_OBJECT_STRUCT *psObj);

// Global (re-usable) instance of an interface for this object
const SKI_CONDITIONS_OBJECT_INTERFACE_STRUCT SKI_CONDITIONS =
{
	/*.eOperationalStatus = */eOperationalStatus,
	/*.eWeatherEvent = */eWeatherEvent,
	/*.eTemperature = */eTemperature,
	/*.eWindCondition = */eWindCondition,
	/*.eSnowConditions = */eSnowConditions,
	/*.eAttributes = */eAttributes,
	/*.un32TimeStamp = */un32TimeStamp,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/

static UN32 gun32SkiCondCounter = 0;

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
#endif /* _SKI_CONDITIONS_OBJ_H_ */
