/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SKI_ATTRIBUTES_OBJ_H_
#define _SKI_ATTRIBUTES_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SKI_ATTRIBUTES_OBJECT_NAME "SKI_ATTRS"

#define SKI_ATTRIBUTES_BASE_AMEN (SKI_AMENITY_SKI_LIFTS)
#define SKI_ATTRIBUTES_MAX_AMEN (SKI_AMENITY_SNOWBOARDING)

  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct ski_attributes_object_struct
{
	BOOLEAN bLiftsAvailable;
	UN8 un8Lifts;
	BOOLEAN bTrailsAvailable;
	TRAILS_DATA_STRUCT sTrailData;
	WEATHER_FLAG_ENUM eMake;
	WEATHER_FLAG_ENUM eGroom;
	WEATHER_FLAG_ENUM eBoard;
	WEATHER_FLAG_ENUM eNight;

} SKI_ATTRIBUTES_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eNumOfLifts (
	SKI_ATTRIBUTES_OBJECT hSkiAttrs,
	UN8 *pun8NumOfLifts
		);

static SMSAPI_RETURN_CODE_ENUM eNumOfTrailsRange (
	SKI_ATTRIBUTES_OBJECT hSkiAttrs,
	UN8 *pun8NumOfTrailsRangeLow,
	UN8 *pun8NumOfTrailsRangeHigh
		);

SMSAPI_RETURN_CODE_ENUM eAmenities (
    SKI_ATTRIBUTES_OBJECT hSkiAttrs,
    size_t tNumAmenities,
    AMENITY_STRUCT *pasSkiAmenities
      );

static N32 n32FPrintf (
	SKI_ATTRIBUTES_OBJECT hSkiAttrs,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const SKI_ATTRIBUTES_OBJECT_INTERFACE_STRUCT SKI_ATTRIBUTES =
{
	/*.eNumOfLifts = */eNumOfLifts,
	/*.eNumOfTrailsRange = */eNumOfTrailsRange,
    /*.eAmenities = */eAmenities,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _SKI_ATTRIBUTES_OBJ_H_ */
