/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SEEK_EVENT_H
#define _SEEK_EVENT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "seek_event.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SEEK_EVENT_OBJECT_NAME "SEEK_EVENT"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static CHANNEL_OBJECT hChannel (
    SEEK_EVENT_OBJECT hSeekEvent
        );

static SEEK_CONTENT_OBJECT hContent (
    SEEK_EVENT_OBJECT hSeekEvent
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global instance of an interface for this object
const SEEK_EVENT_INTERFACE_STRUCT SEEK_EVENT =
{
    /*.hChannel = */hChannel,
    /*.hContent = */hContent
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SEEK_EVENT_H
