/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SEEK_CONTENT_H
#define _SEEK_CONTENT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "seek_content.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SEEK_CONTENT_REGISTERED_ITEM_NAME   "SEEK_REG_ITEM"

#define SEEK_CONTENT_ENABLED                "Enabled"

// DEFAULT_SEEK_CONTENT information definition
const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsDefaultSeekContent =
{
    /*.vUnInit = */NULL,
    /*.n32FPrintf = */NULL,
    /*.bSearchForCurrentAfterEnable = */NULL
};


  /**************/
 /** TYPEDEFS **/
/**************/


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SEEK_SERVICE_ENUM eService (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eRemove (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eEnable (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eDisable (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static BOOLEAN bEnabled (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eUseSeekContent (
    SEEK_CONTENT_OBJECT hSeekContent,
    SEEK_CONTENT_ACCESS_CALLBACK vSeekContentAccessCallback,
    void *pvCallbackArg
        );

/* Object Private Prototypes */

static N32 n32FPrintf (
    SEEK_CONTENT_OBJECT hSeekContent,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global instance of an interface for this object
const SEEK_CONTENT_INTERFACE_STRUCT SEEK_CONTENT =
{
    /*.eService = */eService,
    /*.eRemove = */eRemove,
    /*.eEnable = */eEnable,
    /*.eDisable = */eDisable,
    /*.bEnabled = */bEnabled,
    /*.eUseSeekContent = */eUseSeekContent,
    /*.n32FPrintf = */n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _AT_SEEK_H
