/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SAFECAM_SUBLOCATION_OBJ_H_
#define _SAFECAM_SUBLOCATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SAFECAM_SUBLOCATION_OBJECT_NAME "SAFETY_CAMERAS_SUBLOCATION"


#define SAFECAM_SUBLOCATION_KM_TO_MILES_FRAC 6215
#define SAFECAM_SUBLOCATION_KM_TO_MILES_POW10 4
#define SAFECAM_SUBLOCATION_KM_TO_MILES_WHOLE 0

  /**************/
 /** TYPEDEFS **/
/**************/

// Private object structure
typedef struct safecam_sublocation_object_struct
{
    UN8 un8Id;
    UN16 un16Direction;
    UN16 un16Speed1;
    UN16 un16Speed2;
    BOOLEAN bSpeedInMiles;
    SAFETY_CAMERAS_ALERT_ID tAlertID;
    LOCATION_OBJECT hLocation;
} SAFECAM_SUBLOCATION_OBJECT_STRUCT;


//Public prototypes
static LOCATION_OBJECT hLocation (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc
);

static SMSAPI_RETURN_CODE_ENUM eDirection (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc,
    UN16* pun16Direction
);

static SMSAPI_RETURN_CODE_ENUM eHighSpeedLimit (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc,
    OSAL_FIXED_OBJECT hHighSpeedLimit
);

static SMSAPI_RETURN_CODE_ENUM eLowSpeedLimit (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc,
    OSAL_FIXED_OBJECT hLowSpeedLimit
);


static SAFETY_CAMERAS_ALERT_ID tAlertType (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc
);

static N32 n32FPrintf (
    SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
);

//Private prototypes
static void vDestroyObject(SAFECAM_SUBLOCATION_OBJECT_STRUCT *psObj);

// Global (re-usable) instance of an interface for this object
const SAFETY_CAMERAS_SUBLOCATION_OBJECT_INTERFACE_STRUCT SAFETY_CAMERAS_SUBLOCATION =
{
    /*.hLocation = */hLocation,
    /*.eDirection = */eDirection,
    /*.eHighSpeedLimit = */eHighSpeedLimit,
    /*.eLowSpeedLimit = */eLowSpeedLimit,
    /*.hAlertType = */tAlertType,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _SAFECAM_SUBLOCATION_OBJ_H_
