/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SAFECAM_LOCATION_OBJ_H_
#define _SAFECAM_LOCATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SAFECAM_LOCATION_OBJECT_NAME "SAFETY_CAMERAS_LOCATION"


  /**************/
 /** TYPEDEFS **/
/**************/

// Private object structure
typedef struct safecam_location_object_struct
{
    LOCATION_OBJECT hLocation;
    UN8 un8SubNum;
    OSAL_OBJECT_HDL hSubLocations;
    UN32 un32UID;
    BOOLEAN bInitCompleted;
    BOOLEAN bSpeedInMiles;
} SAFECAM_LOCATION_OBJECT_STRUCT;


//Public prototypes
static LOCATION_OBJECT hLocation (
    SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
);

static SMSAPI_RETURN_CODE_ENUM eIterateSubLocations (
    SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc,
    SAFETY_CAMERAS_SUBLOCATIONS_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
);

static N32 n32FPrintf (
    SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
);

//Private prototypes
static void vDestroyObject(SAFECAM_LOCATION_OBJECT_STRUCT *psObj);

// Global (re-usable) instance of an interface for this object
const SAFETY_CAMERAS_LOCATION_OBJECT_INTERFACE_STRUCT SAFETY_CAMERAS_LOCATION =
{
    /*.hLocation = */hLocation,
    /*.eIterateSubLocations = */eIterateSubLocations,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _SAFECAM_LOCATION_OBJ_H_
