/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _PRECIPITATION_OBJ_H_
#define _PRECIPITATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define PRECIPITATION_OBJECT_NAME "PRECIPITATION"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct precipitation_object_struct
{
	BOOLEAN bPopAvailable;
	BOOLEAN bPrecipAvailable;
	UN8 un8Chance;
	PRECIP_DATA_STRUCT sData;
} PRECIPITATION_OBJECT_STRUCT;


//Prototypes
static SMSAPI_RETURN_CODE_ENUM eType (
	PRECIPITATION_OBJECT hPrecipitation,
	PRECIPITATION_TYPE_ENUM *ePrecipitationType
		);

static SMSAPI_RETURN_CODE_ENUM eAmountRange (
    PRECIPITATION_OBJECT hPrecipitation,
    OSAL_FIXED_OBJECT hRangeLow,
    OSAL_FIXED_OBJECT hRangeHigh
    	);

static SMSAPI_RETURN_CODE_ENUM eChance (
	PRECIPITATION_OBJECT hPrecipitation,
	UN8 *pun8PrecipitationChance
		);

static N32 n32FPrintf (
	PRECIPITATION_OBJECT hPrecipitation,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const PRECIPITATION_OBJECT_INTERFACE_STRUCT PRECIPITATION =
{
	/*.eType = */eType,
	/*.eAmountRange = */eAmountRange,
	/*.eChance = */eChance,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _PRECIPITATION_OBJ_H_ */
