/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _NEWS_OBJ_H_
#define _NEWS_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define NEWS_OBJECT_NAME "NEWS"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static NEWS_ENUM eSubType (
    CD_OBJECT hCDO
        );

static CID_OBJECT hId (
    CD_OBJECT hCDO
        );

/* Object Private Prototypes */

static void vUnInit (
    NEWS_OBJECT_STRUCT *psObj
        );

static N16 n16Equal (
    NEWS_OBJECT_STRUCT *psObj1,
    NEWS_OBJECT_STRUCT *psObj2
        );

static N16 n16Compare (
    NEWS_OBJECT_STRUCT *psObj1,
    NEWS_OBJECT_STRUCT *psObj2
        );

static N32 n32FPrintf (
    const NEWS_OBJECT_STRUCT *psObj,
    FILE *psFile
        );

static BOOLEAN bHasId (
    const NEWS_OBJECT_STRUCT *psObj,
    CID_OBJECT hId
        );

static const char *pacTypeText(
    NEWS_ENUM eType
        );

  /***************/
 /** VARIABLES **/
/***************/

// Default NEWS structure
static const NEWS_OBJECT_STRUCT gsDefaultNews =
{
    NEWS_UNKNOWN,
    CID_INVALID_OBJECT
};

// Local instance of an interface for the CDO object
static const CDO_INTERFACE_STRUCT gsNewsInterface =
{
    /*.bInitialize = */NULL,
    /*.vUnInitialize = */NULL,
    /*.vUnInit = */(void (*)(void *))vUnInit,
    /*.n16Equal = */(N16 (*)(const void *, const void *))n16Equal,
    /*.n16Compare = */(N16 (*)(const void *, const void *))n16Compare,
    /*.n32FPrintf = */(N32 (*)(const void *, FILE *))n32FPrintf,
    /*.bHasId = */(BOOLEAN (*)(const void *, CID_OBJECT))bHasId
};

// NEWS CDO information definition
const CDO_INFO_STRUCT GsNewsInfo =
{
    /*.eType = */CDO_NEWS,
    /*.pacTypeText = */MACRO_TO_STRING(CDO_NEWS),
    /*.pacDescription = */"News",
    /*.pvDefaultObjData = */(void*)&gsDefaultNews,
    /*.psInterface = */&gsNewsInterface
};

// Global (re-usable) instance of an interface for this object
const NEWS_OBJECT_INTERFACE_STRUCT NEWS =
{
    /*.eSubType = */eSubType,
    /*.hId = */hId

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _NEWS_OBJ_H_
