/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _MUSIC_OBJ_H_
#define _MUSIC_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define MUSIC_OBJECT_NAME "MUSIC"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static MUSIC_ENUM eSubType (
    CD_OBJECT hCDO
        );

static CID_OBJECT hArtistId (
    CD_OBJECT hCDO
        );

static CID_OBJECT hSongId (
    CD_OBJECT hCDO
        );

static CID_OBJECT hSongTag (
    CD_OBJECT hCDO,
    SONG_TAG_SERVICE_ENUM eService
        );

/* Object Private Prototypes */

static void vUnInit (
    MUSIC_OBJECT_STRUCT *psObj
        );

static N16 n16Equal (
    MUSIC_OBJECT_STRUCT *psObj1,
    MUSIC_OBJECT_STRUCT *psObj2
        );

static N16 n16Compare (
    MUSIC_OBJECT_STRUCT *psObj1,
    MUSIC_OBJECT_STRUCT *psObj2
        );

static N32 n32FPrintf (
    const MUSIC_OBJECT_STRUCT *psObj,
    FILE *psFile
        );

static BOOLEAN bHasId (
    const MUSIC_OBJECT_STRUCT *psObj,
    CID_OBJECT hId
        );

static const char *pacTypeText(
    MUSIC_ENUM eType
        );

  /***************/
 /** VARIABLES **/
/***************/

// Default MUSIC structure
static const MUSIC_OBJECT_STRUCT gsDefaultMusic =
{
    MUSIC_UNKNOWN,
    CID_INVALID_OBJECT,
    CID_INVALID_OBJECT,
    {
        CID_INVALID_OBJECT
    }
};

// Local instance of an interface for the CDO object
static const CDO_INTERFACE_STRUCT gsMusicInterface =
{
    /*.bInitialize = */NULL,
    /*.vUnInitialize = */NULL,
    /*.vUnInit = */(void (*)(void *))vUnInit,
    /*.n16Equal = */(N16 (*)(const void *, const void *))n16Equal,
    /*.n16Compare = */(N16 (*)(const void *, const void *))n16Compare,
    /*.n32FPrintf = */(N32 (*)(const void *, FILE *))n32FPrintf,
    /*.bHasId = */(BOOLEAN (*)(const void *, CID_OBJECT))bHasId
};

// MUSIC CDO information definition
const CDO_INFO_STRUCT GsMusicInfo =
{
    /*.eType = */CDO_MUSIC,
    /*.pacTypeText = */MACRO_TO_STRING(CDO_MUSIC),
    /*.pacDescription = */"Music",
    /*.pvDefaultObjData = */(void*)&gsDefaultMusic,
    /*.psInterface = */&gsMusicInterface
};

// Global (re-usable) instance of an interface for this object
const MUSIC_OBJECT_INTERFACE_STRUCT MUSIC =
{
    /*.eSubType = */eSubType,
    /*.hArtistId = */hArtistId,
    /*.hSongId = */hSongId,
    /*.hSongTag = */hSongTag
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _MUSIC_OBJ_H_
