/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _MODULE_VER_OBJ_H_
#define _MODULE_VER_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "string_obj.h"


  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define MODULE_VERSION_OBJECT_NAME "MODULE_VERSION"

  /**************/
 /** TYPEDEFS **/
/**************/

#define MODULE_VERSION_STRING_FORMAT_LEN 10
#define MODULE_VERSION_STRING_FORMAT_CAPABILITY_LEN 13
#define MODULE_VERSION_STRING_FORMAT "x%02x-%02x-%02x"
#define MODULE_VERSION_STRING_FORMAT_CAPABILITY "x%02x-%02x-%02x-%02x"

/* Private object elements */

typedef struct module_version_object_struct
{
    char acTypeID[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hTypeID;

    char acHardwareRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hHardwareRevision;

    char acSoftwareRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hSoftwareRevision;

    char acProtocolRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hProtocolRevision;

    char acBaseBandRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hBaseBandRevision;

    char acDecoderRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hDecoderRevision;

    char acRFRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hRFRevision;

    char acSPLRevision[MODULE_VERSION_STRING_FORMAT_LEN];
    STRING_OBJECT hSPLRevision;

    char acCapability[MODULE_VERSION_STRING_FORMAT_CAPABILITY_LEN];
    STRING_OBJECT hCapability;

    char acModuleHwName[MODULE_VERSION_STRING_HW_NAME_LEN];
    STRING_OBJECT hModuleHwName;

    MODULE_VERSION_INFO_STRUCT sModuleVersionData;

} MODULE_VERSION_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static STRING_OBJECT hTypeID(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hHardwareRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hSoftwareRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hProtocolRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hBaseBandRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hDecoderRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hRFRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hSPLRevision(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hCapability(
    MODULE_OBJECT hModule
        );

static STRING_OBJECT hModuleHwName(
    MODULE_OBJECT hModule
        );

static N32 n32FPrintf(
    MODULE_OBJECT hModule,
    FILE *psFile
        );

static SMSAPI_RETURN_CODE_ENUM eFWUpdateFileVersion(
    const char *pcFile,
    STRING_OBJECT  hFileVersion,
    STRING_OBJECT  hFileEarliestVersion,
    STRING_OBJECT  hFileLatestVersion,
    STRING_OBJECT  hFileTypeID
        );

/* Object Private Prototypes */
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromModule(
    MODULE_OBJECT hModule,
    MODULE_VERSION_OBJECT_STRUCT **ppsObj
        );

static void vReleaseStrings(
    MODULE_VERSION_OBJECT hModule
        );

  /***************/
 /** VARIABLES **/
/***************/


static const MODULE_VERSION_OBJECT_STRUCT gsObjectDefaults =
{
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,
    {'\0'},
    STRING_INVALID_OBJECT,

    //sModuleVersionData
    {
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        (char *)NULL,
        //bModuleVersionAvailable
        FALSE,
        0
    }
};


// Global (re-usable) instance of an interface for this object
const MODULE_VERSION_OBJECT_INTERFACE_STRUCT MODULE_VERSION =
{
    /* Object Members */
    /*.hTypeID = */hTypeID,
    /*.hHardwareRevision = */hHardwareRevision,
    /*.hSoftwareRevision = */hSoftwareRevision,
    /*.hProtocolRevision = */hProtocolRevision,
    /*.hBaseBandRevision = */hBaseBandRevision,
    /*.hDecoderRevision = */hDecoderRevision,
    /*.hRFRevision = */hRFRevision,
    /*.hSPLRevision = */hSPLRevision,
    /*.hCapability = */hCapability,
    /*.hModuleHwName */hModuleHwName,
    /*.eFWUpdateVersion */eFWUpdateFileVersion,
    /*.n32FPrintf =*/n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _MODULE_VER_OBJ_H_
