/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _LOCID_OBJ_H_
#define _LOCID_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define LOCID_OBJECT_NAME "LOCID"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct locid_object_struct
{
    // Every LOCID has a LOC_ID and a LOCID_TYPE
    LOC_ID                tID;
    LOCID_TYPE_ENUM       eType;

    // LOCID Interface
    const LOCID_INTERFACE_STRUCT *psInterface;

    // The LOCID Union structure
    LOCID_UNION uLOCID;

} LOCID_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static LOCID_OBJECT hCreate (
    LOC_ID tID
        );

static LOC_ID tID (
    LOCID_OBJECT hLocID
        );

static LOCID_TYPE_ENUM eType (
    LOCID_OBJECT hLocID
        );

static LOCID_OBJECT hDuplicate (
    LOCID_OBJECT hLocID
        );

static N16 n16Compare (
    LOCID_OBJECT hLocID1,
    LOCID_OBJECT hLocID2
        );

COMPILE_TIME_ASSERT(sizeof(UN32) == sizeof(LOC_ID),
    LOCID_n32FWrite_Wrong_LOC_ID_Size);
static N32 n32FWrite (
    LOCID_OBJECT hLocID,
    FILE *psFile
        );

static LOCID_OBJECT hFRead (
    FILE *psFile
        );

static N32 n32FPrintf (
    LOCID_OBJECT hLocID,
    FILE *psFile
        );

static void vDestroy (
    LOCID_OBJECT hLocID
        );

/* Object Private Prototypes */
static const char *pacTypeText(
    LOCID_TYPE_ENUM        eType
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global default interface for the LOCID Superclass
static const LOCID_INTERFACE_STRUCT gsDefaultInterface =
{
    /*.hDuplicate = */NULL,
    /*.n16Compare = */NULL,
    /*.n32FWrite = */NULL,
    /*.n32FPrintf = */NULL
};

// Global (re-usable) instance of an interface for this object
const LOCID_OBJECT_INTERFACE_STRUCT LOCID =
{
    /*.hCreate = */hCreate,
    /*.tID = */tID,
    /*.eType = */eType,
    /*.hDuplicate = */hDuplicate,
    /*.n16Compare = */n16Compare,
    /*.n32FWrite = */n32FWrite,
    /*.hFRead = */hFRead,
    /*.n32FPrintf = */n32FPrintf,
    /*.vDestroy = */vDestroy
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _LOCID_OBJ_H_
