/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _IMAGE_OBJ_H_
#define _IMAGE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define IMAGE_OBJECT_NAME "IMAGE"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */
typedef struct image_object_struct
{
    // Image attributes (for public use)
    IMAGE_FORMAT_ENUM eFormat;
    STRING_OBJECT hFilename;

    // File attributes
    char *pacFilename;

    // Number of objects using
    // this image object
    size_t tNumReferences;

    // Image object specific data
    void *pvSpecificData;

    // Image object interface
    const IMAGE_INTF_STRUCT *psIntf;

} IMAGE_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static IMAGE_FORMAT_ENUM eFormat (
    IMAGE_OBJECT hImage
        );

static STRING_OBJECT hFileName (
    IMAGE_OBJECT hImage
        );

static SMSAPI_RETURN_CODE_ENUM eProperty (
    IMAGE_OBJECT hImage,
    IMAGE_PROPERTY_ENUM ePropety,
    IMAGE_PROPERTY_VALUE_STRUCT *psValue
        );

static SMSAPI_RETURN_CODE_ENUM eImageBackgroundDisplayRules (
    IMAGE_OBJECT hImage,
    BOOLEAN *pbUseBackgroundColor,
    BOOLEAN *pbUseLineBitmap,
    size_t  *tNumLineBitmapEntries,
    RGB_STRUCT *psBackgroundColor
        );

static BOOLEAN bGetLineBitmap (
    IMAGE_OBJECT hImage,
    RGB_STRUCT *psLineBitmap
        );

/* Object Private Prototypes */

static IMAGE_PROPERTY_INTERNAL_ENUM eMapProperty(
    IMAGE_PROPERTY_ENUM eProperty
        );

static SMSAPI_RETURN_CODE_ENUM eMapInternalPropertyValueToPublic (
    IMAGE_PROPERTY_INTERNAL_VALUE_STRUCT const *psIntenalValue,
    IMAGE_PROPERTY_VALUE_STRUCT *psValue
        );

static SMSAPI_RETURN_CODE_ENUM eGetValidPropertyValue(
    IMAGE_OBJECT hImage,
    IMAGE_PROPERTY_INTERNAL_ENUM eProperty,
    IMAGE_PROPERTY_INTERNAL_TYPE_ENUM ePropertyType,
    IMAGE_PROPERTY_INTERNAL_VALUE_STRUCT *psValue
        );

static const char *pacImageFormatName(
    IMAGE_FORMAT_ENUM eFormat
        );

static const char *pacImagePropertyInternalName(
    IMAGE_PROPERTY_INTERNAL_ENUM eInternalProperty
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const IMAGE_INTERFACE_STRUCT IMAGE =
{
    /*.eFormat = */eFormat,
    /*.hFileName = */hFileName,
    /*.eProperty = */eProperty,
    /*.eImageBackgroundDisplayRules = */eImageBackgroundDisplayRules,
    /*.bGetLineBitmap = */bGetLineBitmap
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _IMAGE_OBJ_H_
