/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _HUMIDITY_OBJ_H_
#define _HUMIDITY_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define HUMIDITY_OBJECT_NAME "HUMIDITY"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct humidity_object_struct
{
	BOOLEAN bAvailable;
	HUMIDITY_DATA_STRUCT sData;
} HUMIDITY_OBJECT_STRUCT;


//Prototypes
static SMSAPI_RETURN_CODE_ENUM eRange (
	HUMIDITY_OBJECT hHumidity,
	UN8 *pun8HumidityRangeLow,
	UN8 *pun8HumidityRangeHigh
		);

static N32 n32FPrintf (
	HUMIDITY_OBJECT hHumidity,
	FILE *psFile
		);


// Global (re-usable) instance of an interface for this object
const HUMIDITY_OBJECT_INTERFACE_STRUCT HUMIDITY =
{
	/*.eRange = */eRange,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _HUMIDITY_OBJ_H_ */
