/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _EPROGRAM_OBJ_H_
#define _EPROGRAM_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>

#include "sms_api.h"
#include "eprogram_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define EPG_PROGRAM_DBG_PREFIX              "EPROGRAM"

#define EPG_LONG_DESCRIPTION_LEN            255

/* Objects names */
#define EPG_PROGRAM_EVENT_OBJECT_NAME       "EPG:ProgramEvent"

#define EPG_TOPICS_LIST_OBJECT_NAME         "EPG:TopicsList"
#define EPG_TOPICS_LL_NAME                  EPG_TOPICS_LIST_OBJECT_NAME":TopicsLL"

#define EPG_CHANNEL_OBJECT_NAME             "EPG:Channel"
#define EPG_CHANNEL_EVENTS_LL_NAME          EPG_CHANNEL_OBJECT_NAME":ChannelEventsLL"
#define EPG_CHANNEL_UNIQUE_EVENTS_LL_NAME   EPG_CHANNEL_OBJECT_NAME":UniqueProgramsLL"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SERVICE_ID tChannelSID (
        PROGRAM_OBJECT hEpgEvent
            );

static SERIES_ID tSeriesId (
        PROGRAM_OBJECT hEpgEvent
            );

static PROGRAM_ID tProgramId (
        PROGRAM_OBJECT hEpgEvent
            );

static TIME_T tStartTime (
        PROGRAM_OBJECT hEpgEvent
            );

static TIME_T tEndTime (
        PROGRAM_OBJECT hEpgEvent
            );

static PROGRAM_DAY_ID tEventDay (
        PROGRAM_OBJECT hEpgEvent
            );

static PROGRAM_FLAGS tPFlags (
        PROGRAM_OBJECT hEpgEvent
            ); // 12bit mask - featured/highlited/live/new...

static BOOLEAN bGetShortName (
        PROGRAM_OBJECT hEpgEvent,
        STRING_OBJECT hShortName
            );

static BOOLEAN bGetLongName (
        PROGRAM_OBJECT hEpgEvent,
        STRING_OBJECT hLongName
            );

static BOOLEAN bGetSeriesDescription (
        PROGRAM_OBJECT hEpgEvent,
        STRING_OBJECT hSeriesDescription
            ); // handle to Series description

static BOOLEAN bGetProgramDescription (
        PROGRAM_OBJECT hEpgEvent,
        STRING_OBJECT hProgramDescription
            ); // handle to Program description

static UN16 un16OrigDate (
        PROGRAM_OBJECT hEpgEvent
            ); // day (epoch) when program was originally aired

static EPG_TOPICS_LIST hEpgTopics (
        PROGRAM_OBJECT hEpgEvent
            );

static N32 n32FPrintf(
        PROGRAM_OBJECT hEpgEvent,
        FILE  *psFile
            );

static SMSAPI_RETURN_CODE_ENUM eIterateTopics (
        EPG_TOPICS_LIST hEpgTopics,
        EPG_TOPIC_ITERATOR_CALLBACK bEpgTopicIterator,
        void *pvIteratorArg
            );

static EPG_PROGRAM_RECORDING_OPTION_ENUM eRecordingOption (
        PROGRAM_OBJECT hEpgEvent
            );

/* Object Private Prototypes */

static BOOLEAN bLoadString (
        PROGRAM_OBJECT hEProgEvent,
        UN8 un8SegNum,
        UN32 un32Index,
        STRING_OBJECT hText
            );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const PROGRAM_OBJECT_INTERFACE_STRUCT PROGRAM =
{
 /* tChannelSID = */ tChannelSID,
 /* tSeriesId = */ tSeriesId,
 /* tProgramId = */ tProgramId,
 /* tStartTime = */ tStartTime,
 /* tEndTime = */ tEndTime,
 /* tEventDay = */ tEventDay,
 /* tPFlags = */ tPFlags,
 /* bGetShortName = */ bGetShortName,
 /* bGetLongName = */ bGetLongName,
 /* bGetSeriesDescription = */ bGetSeriesDescription,
 /* bGetProgramDescription = */ bGetProgramDescription,
 /* un16OrigDate = */ un16OrigDate,
 /* hEpgTopics = */ hEpgTopics,
 /* n32FPrintf = */ n32FPrintf,
 /* eIterateTopics = */ eIterateTopics,
 /* eRecordingOption = */ eRecordingOption
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _EPROGRAM_OBJ_H_
