/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _EPG_CACHE_OBJ_H_
#define _EPG_CACHE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>

#include "sms_api.h"
#include "epg_cache_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define EPG_CACHE_DBG_PREFIX                    "EPG CACHE"

/* Objects names */
#define EPG_TEXT_CACHE_OBJECT_NAME              "EPG:TextCache"
#define EPG_COMPRESSED_TEXT_BUF_OBJECT_NAME     EPG_TEXT_CACHE_OBJECT_NAME":CompressedTextBuf"
#define EPG_DECOMPRESSED_TEXT_BUF_OBJECT_NAME   EPG_TEXT_CACHE_OBJECT_NAME":DecompressedTextBuf"
#define EPG_CACHE_INDEX_ARRAY_OBJECT_NAME       EPG_TEXT_CACHE_OBJECT_NAME":CacheIndexArray"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Private functions */

BOOLEAN EPG_TEXT_CACHE_bLoadCompressedTextData(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                               UN8 un8SegNum,
                                               void *pvData,
                                               UN32 un32CompressedSize,
                                               UN32 un32DecompressedSize);

BOOLEAN EPG_TEXT_CACHE_bLoadCompressedFile(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                           UN8 un8SegNum,
                                           FILE *pFile,
                                           UN32 un32CompressedSize,
                                           UN32 un32DecompressedSize);

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _EPG_CACHE_OBJ_H_
