/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DSRL_ENTRY_OBJ_H_
#define _DSRL_ENTRY_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "dataservice_mgr_impl.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DSRL_ENTRY_PREFIX "DE"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct dsrl_entry_data_struct
{
    // A DSRL List entry handle which points to DSRL_ENTRY_STRUCT
    OSAL_LINKED_LIST_ENTRY hDSRLListEntry;

    // The DSRL in which this entry is a member
    DSRL_OBJECT hDSRL;
} DSRL_ENTRY_DATA_STRUCT;


/* Private object elements */

typedef struct dsrl_entry_object_struct
{
    DSRL_ENTRY_TYPE_ENUM eType;

    // This entry's associated service
    DATASERVICE_IMPL_HDL hService;

    // Favorite status of this entry
    BOOLEAN bIsFavorite;

    // Pointer to optional descriptor structure
    void *pvServiceData;

    // List of DSRL_ENTRY_DATA_STRUCT's for every DSRL
    OSAL_OBJECT_HDL hDataList;

    DSRL_ENTRY_DATA_STRUCT *psEntryData;

} DSRL_ENTRY_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static DSRL_ENTRY_TYPE_ENUM eType (
    DSRL_ENTRY_OBJECT hEntry
        );

static TRAFFIC_MSG_OBJECT hTrafficMsg (
    DSRL_ENTRY_OBJECT hEntry
        );

static FUEL_STATION_OBJECT hFuelStation (
    DSRL_ENTRY_OBJECT hEntry
        );

static THEATER_OBJECT hTheater (
    DSRL_ENTRY_OBJECT hEntry
        );

static AGW_TILE_OBJECT hAgwTile (
    DSRL_ENTRY_OBJECT hEntry
        );

static AGW_SHAPE_OBJECT hAgwShape (
    DSRL_ENTRY_OBJECT hEntry
        );

static WEATHER_MSG_OBJECT hWeatherMsg (
    DSRL_ENTRY_OBJECT hEntry
        );

static STOCK_MSG_OBJECT hStockMsg (
    DSRL_ENTRY_OBJECT hEntry
        );

static SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc (
    DSRL_ENTRY_OBJECT hEntry
        );

static WS_ALERT_MSG_OBJECT hWSAlertMsg (
    DSRL_ENTRY_OBJECT hEntry
        );

   /*************************/
  /** PROTOTYPES          **/
 /** FAVORITES INTERFACE **/
/*************************/

static SMSAPI_RETURN_CODE_ENUM eSetFavorite (
    DSRL_ENTRY_OBJECT hEntry,
    BOOLEAN bIsFavorite
        );

static BOOLEAN bIsFavorite (
    DSRL_ENTRY_OBJECT hEntry
        );

static void vClearAllFavorites (
    DATASERVICE_MGR_OBJECT hManager
        );

static SMSAPI_RETURN_CODE_ENUM eSetFavoriteByLocID (
    LOCID_OBJECT hLocID,
    DATASERVICE_MGR_OBJECT hManager,
    BOOLEAN bIsFavorite
        );

static SMSAPI_RETURN_CODE_ENUM eSetFavoriteByStockSymbol (
    STOCK_SYMBOL_OBJECT hStockSymbol,
    DATASERVICE_MGR_OBJECT hManager,
    BOOLEAN bIsFavorite
        );

static N16 n16CompareDSRLs (
    DSRL_ENTRY_DATA_STRUCT *psEntry1,
    DSRL_ENTRY_DATA_STRUCT *psEntry2
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const DSRL_ENTRY_OBJECT_INTERFACE_STRUCT DSRL_ENTRY =
{
    /*.eType = */eType,
    /*.hTrafficMsg = */hTrafficMsg,
    /*.hFuelStation = */hFuelStation,
    /*.hTheater = */hTheater,
    /*.hAgwTile = */hAgwTile,
    /*.hAgwShape = */hAgwShape,
    /*.hWeatherMsg = */hWeatherMsg,
    /*.hStockMsg = */hStockMsg,
    /*.hSafeCamLoc = */hSafeCamLoc,
    /*.hWSAlertMsg = */hWSAlertMsg
};

   /*************************/
  /** VARIABLES ************/
 /** FAVORITES INTERFACE **/
/*************************/

// Global (re-usable) instance of an interface for the Favorites API
const FAVORITES_INTERFACE_STRUCT FAVORITES =
{
    /*.eSetFavorite = */eSetFavorite,
    /*.bIsFavorite = */bIsFavorite,
    /*.vClearAllFavorites = */vClearAllFavorites,
    /*.eSetFavoriteByLocID = */eSetFavoriteByLocID,
    /*.eSetFavoriteByStockSymbol = */eSetFavoriteByStockSymbol
};


  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _DSRL_ENTRY_OBJ_H_
