/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DB_UTIL_H_
#define _DB_UTIL_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "sql_interface_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define DB_UTIL_OBJECT_NAME "DatabaseUtility"

// Timetable Database Commands / Queries

#define DB_UTIL_TIMESTAMP_TABLE_NAME "Timestamp"

// Select all from timestamp
#define DB_UTIL_SELECT_ALL_TIMESTAMPS \
    "select * from "DB_UTIL_TIMESTAMP_TABLE_NAME";"

// Update version row
#define DB_UTIL_UPDATE_TIMESTAMP_ROW \
    "update "DB_UTIL_TIMESTAMP_TABLE_NAME \
    " set modtime=%11i " \
    "where type=%3u;"

  /**************/
 /** TYPEDEFS **/
/**************/

// Timestamp table

// Timestamp table row types
// (only database timestamp at present)

typedef enum db_util_timestamp_types_enum {
    DB_UTIL_TIMESTAMP_TYPE_DB = 0,
    DB_UTIL_TIMESTAMP_MAX_TYPES

} DB_UTIL_TIMESTAMP_TYPES_ENUM;

// Timestamp table column (field) types
typedef enum db_util_timestamp_fields_enum {
    DB_UTIL_TIMESTAMP_TYPE = 0,
    DB_UTIL_TIMESTAMP_TIME,
    DB_UTIL_TIMESTAMP_MAX_FIELDS

} DB_UTIL_TIMESTAMP_FIELDS_ENUM;

// A single database timestamp row
typedef struct db_util_timestamp_row_struct
{
    DB_UTIL_TIMESTAMP_TYPES_ENUM eType; // The type of timestamp data
    UN32 un32Timestamp;                 // The timestamp

} DB_UTIL_TIMESTAMP_ROW_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */


/* Object Private Prototypes */
static SQL_INTERFACE_OBJECT hOpenPersistentDB (
    const char *pacDatabaseFile,
    DB_UTIL_CREATE_DB_HANDLER bCreateDBHandler,
    void *pvCreateArg,
    DATASERVICE_ERROR_CODE_ENUM *peErrorCode
        );

static BOOLEAN bProcessSelectTimestamp (
    SQL_QUERY_COLUMN_STRUCT *psColumn,
    N32 n32NumberOfColumns,
    DB_UTIL_TIMESTAMP_RESULT_STRUCT *psResult
        );

static TIME_T tExtractDatabaseTimestamp (
    SQL_INTERFACE_OBJECT hConnection
        );

static DATASERVICE_ERROR_CODE_ENUM eCheckReferenceBanks (
    const char *pacDatabaseFileA,
    const char *pacDatabaseFileB,
    const char **ppacOldFile,
    const char **ppacNewFile,
    DB_UTIL_EXTRACT_CONTENT_VERSION_HANDLER n32ExtractVersionHandler,
    void *pvExtractVersionHandlerArg,
    DATASERVICE_REF_DATA_VER *ptCurrentVer,
    DATASERVICE_REF_DATA_VER *ptNextVer,
    BOOLEAN *pbDatabaseSwapped,
    size_t tVersionBitWidth
        );

  /***************/
 /** VARIABLES **/
/***************/


  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _DB_UTIL_H_
