/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _CID_STRING_H_
#define _CID_STRING_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "cid_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

  /************/
 /** MACROS **/
/************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global structure defining the CID STRING Object Data Interface
const CID_TYPE_OBJ_DATA_INTERFACE_STRUCT GsCidStringIntf =
{
    // Object Data Minimum size
    /*.tMinSize = */0,

    // Object Data Create/Destroy Methods
    /*.pvCreate = */CIDSTR_pvCreate,
    /*.vDestroy = */CIDSTR_vDestroy,

    // Object Data Manipulation Methods
    /*.pvDuplicate = */CIDSTR_pvDuplicate,
    /*.bModify = */CIDSTR_bModify,
    /*.bCopy = */CIDSTR_bCopy,
    /*.tSize = */CIDSTR_tSize,
    /*.n16Compare = */CIDSTR_n16Compare,

    // Object Data I/O Methods
    /*.n32FWrite = */CIDSTR_n32FWrite,
    /*.n32FWriteToMemory = */CIDSTR_n32FWriteToMemory,
    /*.pvRead = */CIDSTR_pvRead,
    /*.bReadFromMemory = */CIDSTR_bReadFromMemory,
    /*.n32FPrintf = */CIDSTR_n32FPrintf,
    /*.n32GetValue = */CIDSTR_n32GetValue
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CID_STRING_H_
