/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _CHANNEL_OBJ_H_
#define _CHANNEL_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "sms_update.h"
#include "dataservice_mgr_obj.h"
#include "presets_obj.h"
#include "eprogram_obj.h"
  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define CHANNEL_OBJECT_NAME "CHANNEL"

// Attributes which are set by broadcast. Note we do
// not consider subscription a broadcast attribute since
// we determine subscription via another mechanism.
#define CHANNEL_OBJECT_ATTRIBUTE_BROADCAST (    \
    (CHANNEL_OBJECT_ATTRIBUTE_MASK)             \
     CHANNEL_OBJECT_ATTRIBUTE_FREE_TO_AIR |     \
     CHANNEL_OBJECT_ATTRIBUTE_MATURE |          \
     CHANNEL_OBJECT_ATTRIBUTE_SUB_ALERT         \
        )

#define CHANNEL_OBJECT_ATTRIBUTE_USER (         \
    (CHANNEL_OBJECT_ATTRIBUTE_MASK)             \
     CHANNEL_OBJECT_ATTRIBUTE_LOCKED |          \
     CHANNEL_OBJECT_ATTRIBUTE_SKIPPED           \
        )

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct channel_iterator_struct
{
    CHANNEL_OBJECT_ITERATOR bIterator;
    CHANNEL_OBJECT_ITERATOR_INCLUDE_HANDLER bInclude;
    void *pvArg;

} CHANNEL_ITERATOR_STRUCT;

typedef struct channel_similar_struct
{
    // Array of Similar Channel service IDs
    SERVICE_ID *ptServiceIds;

    // Current number of channels in array
    UN32 un32Items;

    // Array size
    UN32 un32Size;

} CHANNEL_SIMILAR_STRUCT;

typedef struct channel_object_struct
{
    // Channel service id
    SERVICE_ID tServiceId;

    // Channel type
    CHANNEL_TYPE_ENUM eType;

    // Channel attributes
    CHANNEL_OBJECT_ATTRIBUTE_MASK tAttributes;

    // Channel unconfirmed attributes
    CHANNEL_OBJECT_ATTRIBUTE_MASK tUnconfirmedAttributes;

    // Channel info (derived)
    CHANNEL_ID tId;
    STRING_OBJECT hShortName;
    STRING_OBJECT hMediumName;
    STRING_OBJECT hLongName;

    // Channel Descriptions
    STRING_OBJECT hShortDesc;
    STRING_OBJECT hLongDesc;

    // Similar Channel List
    CHANNEL_SIMILAR_STRUCT sSimilarChannels;

    // Content Description Object
    CD_OBJECT hCDO;

    // Current Preset Entries
    CHANNEL_PRESET_HDL hBasePresetHdl;
    CHANNEL_PRESET_HDL hCurrentPresetHdl;

    // Channel Art Handles
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService;
    CHANNEL_ART_OBJECT hArt;

    // Channel Art version
    CHANNEL_ART_VERSION tArtVersion;

    // Reference (base) category
    OSAL_LINKED_LIST_ENTRY hReferenceCategoryEntry;

    // Categories associated with this channel object
    OSAL_OBJECT_HDL hCategoryList;

    // Channel Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

    // Currently filtered notifications for this channel
    SMSAPI_EVENT_MASK tFilter;

    // Use counter
    size_t tUsageCounter;

    //EPG Programs list
    EPG_CHANNEL_OBJECT hEpgObjectsList;

    // Play On Select Method
    CHANNEL_PLAY_ON_SELECT_METHOD_ENUM ePlayOnSelectMethod;

    // Content Type
    CONTENT_TYPE_ENUM eContentType;

    // IR Navigation Class
    IR_NAVIGATION_CLASS_ENUM eIRNavigationClass;

    // Alternate Channel Order
    CHANNEL_ACO tACO;

} CHANNEL_OBJECT_STRUCT;

typedef struct channel_similar_compare_struct
{
    CHANNEL_OBJECT hChannel;
    BOOLEAN bDifferent;

} CHANNEL_SIMILAR_COMPARE_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static CHANNEL_EVENT_MASK tEventMask (
    CHANNEL_OBJECT hChannel
        );

static SERVICE_ID tServiceId (
    CHANNEL_OBJECT hChannel
        );

static CHANNEL_ID tChannelId (
    CHANNEL_OBJECT hChannel
        );

static STRING_OBJECT hShortName (
    CHANNEL_OBJECT hChannel
        );

static STRING_OBJECT hMediumName (
    CHANNEL_OBJECT hChannel
        );

static STRING_OBJECT hLongName (
    CHANNEL_OBJECT hChannel
        );

static STRING_OBJECT hShortDescription (
    CHANNEL_OBJECT hChannel
        );

static STRING_OBJECT hLongDescription (
    CHANNEL_OBJECT hChannel
        );

static SMSAPI_RETURN_CODE_ENUM eCategoryOffset(
    CHANNEL_OBJECT hChannel,
    CATEGORY_ID tCategoryId,
    N16 *pn16Offset
        );

static SMSAPI_RETURN_CODE_ENUM eNumCategories(
    CHANNEL_OBJECT hChannel,
    N16 *pn16NumCategories
        );

static CATEGORY_OBJECT hCategory (
    CHANNEL_OBJECT hChannel,
    N16 n16Offset
        );

static CD_OBJECT hCDO (
    CHANNEL_OBJECT hChannel
        );

static CHANNEL_ART_OBJECT hArt (
    CHANNEL_OBJECT hChannel
        );

static SMSAPI_RETURN_CODE_ENUM ePreset (
    CHANNEL_OBJECT hChannel,
    PRESET_BAND_OBJECT *phBand,
    STRING_OBJECT *phPresetName,
    size_t *ptPresetIndex
        );

static SMSAPI_RETURN_CODE_ENUM eIsLocked (
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbLocked
        );

static SMSAPI_RETURN_CODE_ENUM eIsSkipped (
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbSkipped
        );

static SMSAPI_RETURN_CODE_ENUM eIsSubscribed (
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbSubscribed
        );

static SMSAPI_RETURN_CODE_ENUM eIsMature (
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbMature
        );

static SMSAPI_RETURN_CODE_ENUM eIsFreeToAir (
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbFreeToAir
        );

static SMSAPI_RETURN_CODE_ENUM eIterateSimilarChannels (
    CHANNEL_OBJECT hChannel,
    CHANNEL_SIMILAR_ITERATOR_CALLBACK bSimilarIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eIteratePrograms (
    CHANNEL_OBJECT hChannel,
    PROGRAM_ITERATOR_CALLBACK vEpgIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eNotifyOnChange (
    DECODER_OBJECT hDecoder,
    CHANNEL_OBJECT_EVENT_CALLBACK vNotifierCallback,
    void *pvNotifierCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eIterateAll (
    DECODER_OBJECT hDecoder,
    CHANNEL_OBJECT_ITERATOR bIterator,
    CHANNEL_OBJECT_ITERATOR_INCLUDE_HANDLER bInclude,
    void *pvArg
        );

static CHANNEL_ACO tACO (
    CHANNEL_OBJECT hChannel
        );

static BOOLEAN bQualifiedForTuneMix (
    CHANNEL_OBJECT hChannel
        );

static SMSAPI_RETURN_CODE_ENUM ePlayOnSelect (
    CHANNEL_OBJECT hChannel,
    CHANNEL_PLAY_ON_SELECT_METHOD_ENUM *pePlayOnSelect
        );

/* Object Private Prototypes */

static BOOLEAN bRemoveChannelFromCategory(
    void *pvData,
    void *pvArg
        );

static BOOLEAN bUpdateStringLocal(
    CHANNEL_OBJECT_STRUCT *psObj,
    STRING_OBJECT *phString,
    UN16 un16MaxLength,
    const char *pacName,
    SMSAPI_EVENT_MASK tMask
        );

static CHANNEL_EVENT_MASK tGetEventsForUnsubscribedCDOChange (
    CHANNEL_OBJECT_STRUCT *psObj
        );

static CHANNEL_EVENT_MASK tGetEventsForSubscriptionAlertCDOChange (
    CHANNEL_OBJECT_STRUCT *psObj
        );

static BOOLEAN bAlwaysInclude (
    CHANNEL_OBJECT hChannel,
    void *pvArg
        );

static BOOLEAN bIteratorShim (
    CHANNEL_OBJECT hChannel,
    void *pvArg
        );

static BOOLEAN bRemoveCategory (
    CHANNEL_OBJECT_STRUCT *psObj,
    CATEGORY_OBJECT hCategory,
    BOOLEAN bSuppressCatEvents
        );

static CHANNEL_EVENT_MASK tGetEventsForCDOChange (
    CHANNEL_OBJECT_STRUCT *psObj,
    CHANNEL_OBJECT_STRUCT *psDummyObj
        );

static N16 n16CompareCategoryIds(
    CATEGORY_OBJECT hCategory1,
    CATEGORY_OBJECT hCategory2
        );

static BOOLEAN bCompareSimilarChannelsOuter(
    CHANNEL_OBJECT hChannel,
    void *pvEventCallbackArg
        );

static BOOLEAN bCompareSimilarChannelsNewerInner(
    CHANNEL_OBJECT hChannel,
    void *pvEventCallbackArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const CHANNEL_OBJECT_INTERFACE_STRUCT CHANNEL =
{
    // Public
    /*.tEventMask = */tEventMask,
    /*.tServiceId = */tServiceId,
    /*.tChannelId = */tChannelId,
    /*.hShortName = */hShortName,
    /*.hMediumName = */hMediumName,
    /*.hLongName = */hLongName,
    /*.hShortDescription = */hShortDescription,
    /*.hLongDescription = */hLongDescription,
    /*.eCategoryOffset = */eCategoryOffset,
    /*.eNumCategories = */eNumCategories,
    /*.hCategory = */hCategory,
    /*.hCDO = */hCDO,
    /*.hArt = */hArt,
    /*.ePreset = */ePreset,
    /*.eIsLocked = */eIsLocked,
    /*.eIsSkipped = */eIsSkipped,
    /*.eIsSubscribed = */eIsSubscribed,
    /*.eIsMature = */eIsMature,
    /*.eIsFreeToAir = */eIsFreeToAir,
    /*.eNotifyOnChange = */eNotifyOnChange,
    /*.eIterateAll = */eIterateAll,
    /*.eIterateSimilarChannels = */eIterateSimilarChannels,
    /*.eIteratePrograms = */eIteratePrograms,
    /*.tACO = */tACO,
    /*.bQualifiedForTuneMix = */bQualifiedForTuneMix,
    /*.ePlayOnSelect = */ePlayOnSelect
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _CHANNEL_OBJ_H_
