/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _CDO_OBJ_H_
#define _CDO_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

// Specific content object's includes
#include "report_obj.h"
#include "music_obj.h"
#include "entertainment_obj.h"
#include "news_obj.h"
#include "non_program_obj.h"
#include "sports_obj.h"

#include "sms_api.h"
#include "cdo_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define CD_OBJECT_NAME "CDO"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef union cdo_union
{
    // CDO's
    // Any CDO structure can be one of the following;
    REPORT_OBJECT_STRUCT sReport;
    MUSIC_OBJECT_STRUCT sMusic;
    SPORTS_OBJECT_STRUCT sSports;
    NEWS_OBJECT_STRUCT sNews;
    ENTERTAINMENT_OBJECT_STRUCT sEntertainment;
    NON_PROGRAM_OBJECT_STRUCT sNonProgram;

} CDO_UNION;

typedef struct cdo_mapping_struct
{
    // CDO Interface
    const CDO_INFO_STRUCT *psInfo;

    // CID associated with this type
    CID_OBJECT hId;

    // CDO Parser associated with this type
    CDO_ID_PARSER bParser;

} CDO_TYPE_MAPPING_STRUCT;

typedef struct cdo_struct
{
    // CDO mapped structure
    CDO_TYPE_MAPPING_STRUCT *psMap;

    // The CDO container union
    CDO_UNION uCDO;

} CDO_STRUCT;

typedef struct cdo_object_struct
{
    // Content Program ID
    PROGRAM_ID tProgramId;

    // Content Id Artist Text
    CID_OBJECT hArtist;

    // Content Id Title Text
    CID_OBJECT hTitle;

    // Content Id Composer Text
    CID_OBJECT hComposer;

    // Content Id Album Name
    CID_OBJECT hAlbum;

    // Content Id Content Info Text
    CID_OBJECT hContentInfo;

    // Channel Art Handles
    CHANNEL_ART_OBJECT hArt;

    // CDO Associated with this CDO
    CDO_STRUCT sCDO;

} CD_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

// Computes the number of CDO types we support based on what is instrumented
// in the information structure.
#define CDO_NUM_TYPES (sizeof(gasTypeMap)/sizeof(CDO_TYPE_MAPPING_STRUCT))

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static CDO_TYPE_ENUM eType (
    CD_OBJECT hCDO
        );

static CID_OBJECT hId (
    CD_OBJECT hCDO
        );

static const char *pacDescription (
    CD_OBJECT hCDO
        );

static STRING_OBJECT hArtist (
    CD_OBJECT hCDO
        );

static CID_OBJECT hArtistId (
    CD_OBJECT hCDO
        );

static STRING_OBJECT hTitle (
    CD_OBJECT hCDO
        );

static CID_OBJECT hTitleId (
    CD_OBJECT hCDO
        );

static STRING_OBJECT hComposer (
    CD_OBJECT hCDO
        );

static CID_OBJECT hComposerId (
    CD_OBJECT hCDO
        );

static STRING_OBJECT hAlbum (
    CD_OBJECT hCDO
    );

static STRING_OBJECT hContentInfo (
    CD_OBJECT hCDO
        );

static CID_OBJECT hContentInfoId (
    CD_OBJECT hCDO
        );

static CHANNEL_ART_OBJECT hArt (
        CD_OBJECT hCDO
        );

static N16 n16Compare (
    CD_OBJECT hCDO1,
    CD_OBJECT hCDO2
        );

static BOOLEAN bIterateTypes (
    CDO_ITERATOR_CALLBACK bIteratorCallback,
    void *pvIteratorCallbackArg
        );

static N32 n32FPrintf (
    CD_OBJECT hCDO,
    FILE *psFile
        );

/* Object Private Prototypes */

static void vInit (
    CDO_STRUCT *psObj
        );

static void vUnInit (
    CDO_STRUCT *psObj
        );

static void vUnInitDefault (
    const CDO_UNION *puObj
        );

static N16 n16EqualDefault (
    const CDO_UNION *puObj1,
    const CDO_UNION *puObj2
        );

static N16 n16CompareDefault (
    const CDO_UNION *puObj1,
    const CDO_UNION *puObj2
        );

static N32 n32FPrintfDefault (
    const CDO_UNION *puObj,
    FILE *psFile
        );

  /***************/
 /** VARIABLES **/
/***************/

// External references to CDO information for populating in the
// CDO type mapping structure below.
extern const CDO_INFO_STRUCT GsReportInfo;
extern const CDO_INFO_STRUCT GsMusicInfo;
extern const CDO_INFO_STRUCT GsEntertainmentInfo;
extern const CDO_INFO_STRUCT GsNewsInfo;
extern const CDO_INFO_STRUCT GsNonProgramInfo;
extern const CDO_INFO_STRUCT GsSportsInfo;

// An initialized default CDO union structure for unknown
// or invalid CDO's
static const CDO_UNION uDefaultCDO =
{
 //REPORT_OBJECT_STRUCT
 {CID_INVALID_OBJECT, NULL}
/*
 //MUSIC_OBJECT_STRUCT
 {MUSIC_UNKNOWN, CID_INVALID_OBJECT, CID_INVALID_OBJECT, {CID_INVALID_OBJECT}},
 //SPORTS_OBJECT_STRUCT
 {CID_INVALID_OBJECT, NULL, LEAGUE_INVALID_OBJECT, OSAL_INVALID_OBJECT_HDL},
 //NEWS_OBJECT_STRUCT
 {NEWS_UNKNOWN, CID_INVALID_OBJECT},
 //ENTERTAINMENT_OBJECT_STRUCT
 {ENTERTAINMENT_UNKNOWN, CID_INVALID_OBJECT},
 //NON_PROGRAM_OBJECT_STRUCT
 {NON_PROGRAM_UNKNOWN, CID_INVALID_OBJECT},
*/
};

// Default CDO interface definition. This is an interface definition
// which is used whenever the CDO type is either unknown or invald.
// It provides default methods which are overridden by specifc CDOs
static const CDO_INTERFACE_STRUCT gsDefaultInterface =
{
    /*.bInitialize = */(BOOLEAN (*) ( void ))NULL,
    /*.vUnInitialize = */(void (*) ( void ))NULL,
    /*.vUnInit = */(void (*)(void *))vUnInitDefault,
    /*.n16Equal = */(N16 (*)(const void *, const void *))n16EqualDefault,
    /*.n16Compare = */(N16 (*)(const void *, const void *))n16CompareDefault,
    /*.n32FPrintf = */(N32 (*)(const void *, FILE *))n32FPrintfDefault,
    /*.bHasId = */NULL
};

// Default 'unknown' CDO information definition
static const CDO_INFO_STRUCT gsUnknownInfo =
{
    /*.eType = */CDO_UNKNOWN,
    /*.pacTypeText = */MACRO_TO_STRING(CDO_UNKNOWN),
    /*.pacDescription = */"Unknown Content Type",
    /*.pvDefaultObjData = */(void*)&uDefaultCDO,
    /*.psInterface = */&gsDefaultInterface
};

// Default 'invalid' CDO information definition
static const CDO_INFO_STRUCT gsInvalidInfo =
{
    /*.eType = */CDO_INVALID,
    /*.pacTypeText = */MACRO_TO_STRING(CDO_INVALID),
    /*.pacDescription = */"Invalid Content Type",
    /*.pvDefaultObjData = */(void*)&uDefaultCDO,
    /*.psInterface = */&gsDefaultInterface
};

// Final Content Description Object structure to map content type
// to their corresponding content type information structures.
// This mapping structure is used extensively to map CDO
// to information and interfaces.
static CDO_TYPE_MAPPING_STRUCT gasTypeMap[] =
{
    // ENTERTAINMENT
    {
        &GsEntertainmentInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // MUSIC
    {
        &GsMusicInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // NEWS
    {
        &GsNewsInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // NON-PROGRAM
    {
        &GsNonProgramInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // REPORT
    {
        &GsReportInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // SPORTS
    {
        &GsSportsInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // UNKNOWN
    {
        &gsUnknownInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    },
    // INVALID
    {
        &gsInvalidInfo,
        CID_INVALID_OBJECT,
        CDO_INVALID_ID_PARSER
    }
};

// A pointer to the CDO map entry to use for 'unknown' CDOs
// This is determined at initialization.
static CDO_TYPE_MAPPING_STRUCT *gpsDefaultMapEntry = NULL;

// Global (re-usable) instance of an interface for this object
const CD_OBJECT_INTERFACE_STRUCT CDO =
{
    /*.eType = */eType,
    /*.hId = */hId,
    /*.pacDescription = */pacDescription,
    /*.hArtist = */hArtist,
    /*.hArtistId = */hArtistId,
    /*.hTitle = */hTitle,
    /*.hTitleId = */hTitleId,
    /*.hComposer = */hComposer,
    /*.hComposerId = */hComposerId,
    /*.hAlbum = */hAlbum,
    /*.hContentInfo = */hContentInfo,
    /*.hContentInfoId = */hContentInfoId,
    /*.hArt = */hArt,
    /*.n16Compare = */n16Compare,
    /*.bIterateTypes = */bIterateTypes,
    /*.n32FPrintf = */n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CDO_OBJ_H_
