/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _CAR_OBJ_H_
#define _CAR_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define CAR_OBJECT_NAME "CAR"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

#ifdef SXM_LEGACY_SSP
static CAR_OBJECT hCreate(
          LEAGUE_ENUM eLeague,
          CID_OBJECT hCarId,
          const char *pacCarNumber,
          const char *pacDriverName,
          const char *pacNickname
              );
#endif

static STRING_OBJECT hCarNumber (
    CAR_OBJECT hCar
        );

static STRING_OBJECT hDriverName (
    CAR_OBJECT hCar
        );


static BOOLEAN bIterateContent (
    LEAGUE_OBJECT hLeague,
    CAR_CONTENT_ITERATOR_CALLBACK bContentIteratorCallback,
    void *pvContentIteratorCallbackArg
        );

/* Object Private Prototypes */


  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const CAR_OBJECT_INTERFACE_STRUCT CAR =
{
#ifdef SXM_LEGACY_SSP
    /*.hCreate = */hCreate,
#endif
    /*.hDriverName = */hDriverName,
    /*.hCarNumber = */hCarNumber,
    /*.bIterateContent = */bIterateContent
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CAR_OBJ_H_
