/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _CAL_CONTENT_H
#define _CAL_CONTENT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "cal_content.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// Object name prefix for objects
#define CAL_CONTENT_OBJECT_NAME "CAL_CONTENT_OBJECT"

  /**************/
 /** TYPEDEFS **/
/**************/

//  The main CAL Content (CAL_CONTENT_OBJECT) structure used to keep
//  registered content.
typedef struct cal_content_object_struct
{
    // the ceml this content is in
    CEML_OBJECT hCEML;

    // The state of this CAL_CONTENT_OBJECT obj
    CAL_CONTENT_STATE_ENUM eState;

    BOOLEAN bEnabled;

    // The app provided argument
    void *pvContentArg;

    // options to determine alert occurance
    UN32 un32Options;

    // artist text
    STRING_OBJECT hArtistText;

    // title text
    STRING_OBJECT hTitleText;

    // the ll which contains alerts that have occurred for this content
    OSAL_OBJECT_HDL hAlertList;

} CAL_CONTENT_OBJECT_STRUCT;


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eRemove (
    CAL_CONTENT_OBJECT hContent
        );

static CID_OBJECT hCID (
    CAL_CONTENT_OBJECT hContent
        );

static CAL_CONTENT_STATE_ENUM eState (
    CAL_CONTENT_OBJECT hContent
        );

static void *pvContentArg (
    CAL_CONTENT_OBJECT hContent
        );

static UN32 un32Options (
    CAL_CONTENT_OBJECT hContent
        );

static BOOLEAN bEnabled (
    CAL_CONTENT_OBJECT hContent
        );

static SMSAPI_RETURN_CODE_ENUM eEnable (
    CAL_CONTENT_OBJECT hContent
        );

static SMSAPI_RETURN_CODE_ENUM eDisable (
    CAL_CONTENT_OBJECT hContent
        );

static STRING_OBJECT hArtistText (
    CAL_CONTENT_OBJECT hContent
        );

static STRING_OBJECT hTitleText (
    CAL_CONTENT_OBJECT hContent
        );

static SMSAPI_RETURN_CODE_ENUM eSearchForCurrent (
    CAL_CONTENT_OBJECT hContent
        );

/* Object Private Prototypes */

static void vUpdateState (
    CAL_CONTENT_OBJECT_STRUCT *psObj,
    CAL_CONTENT_STATE_ENUM eNextState
        );

static N16 n16CompareChannel (
    void *pvArg1,
    void *pvArg2
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global instance of an interface for this object
const CAL_CONTENT_OBJECT_INTERFACE_STRUCT CAL_CONTENT =
{
    /*.eRemove = */eRemove,
    /*.hCID = */hCID,
    /*.eState = */eState,
    /*.pvContentArg = */pvContentArg,
    /*.un32Options = */un32Options,
    /*.bEnabled = */bEnabled,
    /*.eEnable = */eEnable,
    /*.eDisable = */eDisable,
    /*.hArtistText = */hArtistText,
    /*.hTitleText = */hTitleText,
    /*.eSearchForCurrent = */eSearchForCurrent
};
  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CAL_CONTENT_H
