/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _CAL_ALERT_H
#define _CAL_ALERT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "cal_alert.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define CAL_ALERT_OBJECT_NAME "CAL_ALERT"

  /**************/
 /** TYPEDEFS **/
/**************/

//  The main CAL Alert (CAL_ALERT_OBJECT) structure
typedef struct cal_alert_object_struct
{
    // the channel the registered content was found on
    CHANNEL_OBJECT hChannel;

    // the registered content causing the alert
    CAL_CONTENT_OBJECT hContent;

} CAL_ALERT_OBJECT_STRUCT;

typedef struct cal_alert_remove_chan_by_id_struct
{
    // the service id
    SERVICE_ID tServiceId;
    // the channel id
    CHANNEL_ID tChannelId;
    size_t tNumIterations;

}CAL_ALERT_ITERATE_CATEGORY_STRUCT;

typedef struct cal_iterator_struct
{
	CHANNEL_OBJECT hChannel;
    BOOLEAN bFound;

}CAL_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eAddToCategory (
    CAL_ALERT_OBJECT hAlert,
    BOOLEAN bAddDuplicate
        );

static SMSAPI_RETURN_CODE_ENUM eTune (
    CAL_ALERT_OBJECT hAlert,
    BOOLEAN bLockOverride
        );

static CHANNEL_OBJECT hChannel (
    CAL_ALERT_OBJECT hAlert
        );

static CAL_CONTENT_OBJECT hContent (
    CAL_ALERT_OBJECT hAlert
        );

/* Object Private Prototypes */

static N16 n16AddToTopIterator(
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static N16 n16RemoveChanByIdIterateFxn(
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static BOOLEAN bCALIterator(
    CAL_CONTENT_OBJECT hContent,
    void *pvContentIteratorArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global instance of an interface for this object
const CAL_ALERT_OBJECT_INTERFACE_STRUCT CAL_ALERT =
{
    /*.eAddToCategory = */eAddToCategory,
    /*.eTune = */eTune,
    /*.hChannel = */hChannel,
    /*.hContent = */hContent
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CAL_ALERT_H
