/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _BAUDOT_H_
#define _BAUDOT_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Name prefix for debug output */
#define BAUDOT_NAME "Baudot"

// The number of characters we'll read in to
// a local (stack allocated) buffer before
// we're forced to flush to a STRING object.
#define BAUDOT_BLOCK_SIZE (32)

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hToString (
    OSAL_BUFFER_HDL hBuffer,
    BAUDOT_BEHAVIOR_ENUM eProcessBehavior,
    BOOLEAN bStringStartsWithLetters,
    BOOLEAN bStringStartsWithCaps,
    size_t tMaxBaudotSymbolsToRead,
    size_t *ptNumSymbolsFound
        );

/* Object Private Prototypes */

static STRING_OBJECT hTranslateBaudotToANSI (
    SMS_OBJECT hStringOwner,
    OSAL_BUFFER_HDL hBuffer,
    BAUDOT_BEHAVIOR_ENUM eProcessBehavior,
    BOOLEAN bStringStartsWithLetters,
    BOOLEAN bStringStartsWithCaps,
    size_t tMaxBaudotSymbolsToRead,
    size_t *ptNumSymbolsFound
        );

static BOOLEAN bUpdateString (
    SMS_OBJECT hStringOwner,
    STRING_OBJECT *phString,
    const char *pacNewText
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const BAUDOT_INTERFACE_STRUCT BAUDOT =
{
    /*.hToString = */hToString
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _BAUDOT_H_
