/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _AIR_OBJ_H_
#define _AIR_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

/* Object name prefix for objects */
#define AIR_OBJECT_NAME "AIR"

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct air_object_struct
{
	BOOLEAN bQualityAvailable;
	AIR_QUALITY_ENUM eQuality;
	BOOLEAN bPollenAvailable;
	POLLEN_DATA_STRUCT sData;
} AIR_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eQuality (
	AIR_OBJECT hAir,
	AIR_QUALITY_ENUM *peAirQuality
		);

static SMSAPI_RETURN_CODE_ENUM ePollenCount (
	AIR_OBJECT hAir,
	UN8 *pun8PollenCount
		);

static SMSAPI_RETURN_CODE_ENUM ePollenLevel (
	AIR_OBJECT hAir,
	AIR_POLLEN_LEVEL_ENUM *pePollenLevel
		);

static N32 n32FPrintf(
	AIR_OBJECT hAir,
    FILE *psFile
        );

/* Object Private Prototypes */

static const char *pacAirQuality (
    AIR_QUALITY_ENUM eQuality
        );

// Global (re-usable) instance of an interface for this object
const AIR_OBJECT_INTERFACE_STRUCT AIR =
{
	/*.eQuality = */eQuality,
	/*.ePollenCount = */ePollenCount,
	/*.ePollenLevel = */ePollenLevel,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _AIR_OBJ_H_ */
