/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_STORM_POSITION_OBJ_H_
#define _AGW_STORM_POSITION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "agw_storm_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_STORM_POSITION_OBJECT_NAME "AGW_STORM_POSITION"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_storm_position_object_struct
{
    // Storm object
    AGW_STORM_OBJECT hStorm;

    // Keeps list of Wind RADII objects
    OSAL_OBJECT_HDL hWindRadiiList;

    // Storm position data
    AGW_STORM_POSITION_DATA_STRUCT sData;

} AGW_STORM_POSITION_OBJECT_STRUCT;

// Positions iteration callback
typedef struct agw_wind_radii_iterate_shim_arg_struct
{
    // Callback function
    AGW_SHAPE_CALLBACK bIteratorCallback;

    // Callback arg
    void *pvIteratorCallback;
} AGW_WIND_RADII_ITERATE_SHIM_ARG_STRUCT;

typedef struct agw_wind_radii_intersection_check_arg_struct
{
    // Location to intersect
    const AGW_LOCATION_DESC_STRUCT *psLocDesc;

    // Result
    AGW_RETURN_CODE_ENUM eResult;
} AGW_WIND_RADII_INTERSECTION_CHECK_ARG_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hStormID(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static STRING_OBJECT hStormName(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static AGW_STORM_POSITION_TYPE_ENUM ePositionType(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static SMSAPI_RETURN_CODE_ENUM eDirection (
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    OSAL_FIXED_OBJECT hDirection
        );

static SMSAPI_RETURN_CODE_ENUM eSpeed (
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    OSAL_FIXED_OBJECT hSpeed
        );

static SMSAPI_RETURN_CODE_ENUM eMaxSustainedWinds (
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    OSAL_FIXED_OBJECT hMaxWinds
        );

static SMSAPI_RETURN_CODE_ENUM eGusts (
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    OSAL_FIXED_OBJECT hGusts
        );

static SMSAPI_RETURN_CODE_ENUM ePressure (
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    OSAL_FIXED_OBJECT hPressure
        );

static TIME_T tObservationTime(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static AGW_STORM_TYPE_ENUM eStormType(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static UN16 un16SequenceID(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

static N32 n32FPrintf(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static SMSAPI_RETURN_CODE_ENUM eIterateWindRadii(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    AGW_SHAPE_CALLBACK bCallback,
    void *pvArg
        );

static SMSAPI_RETURN_CODE_ENUM eIterateStormPosition(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    AGW_SHAPE_CALLBACK bCallback,
    void *pvArg
        );

/* Callbacks */
static AGW_RETURN_CODE_ENUM eStormPositionHasIntersection (
    AGW_SHAPE_OBJECT hShape,
    const AGW_LOCATION_DESC_STRUCT *psLocDesc
        );

/* Private function */
static BOOLEAN bStormPositionHasIntersectionWindRadiiIterator(
    AGW_SHAPE_OBJECT hWindRadiiShape,
    void *pvArg
        );

static BOOLEAN bIterateWindRadiiShimCallback(
    void *pvData,
    void *pvArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_STORM_POSITION_OBJECT_INTERFACE_STRUCT AGW_STORM_POSITION = {
    /* hStormID = */ hStormID,
    /* hStormName = */ hStormName,
    /* ePositionType = */ ePositionType,
    /* eDirection = */ eDirection,
    /* eSpeed = */ eSpeed,
    /* eMaxSustainedWinds = */ eMaxSustainedWinds,
    /* eGusts = */ eGusts,
    /* ePressure = */ ePressure,
    /* tObservationTime = */ tObservationTime,
    /* eStormType = */ eStormType,
    /* un16SequenceID = */ un16SequenceID,
    /* eIterateWindRadii = */ eIterateWindRadii,
    /* eIterateStormPosition = */ eIterateStormPosition,
    /* n32FPrintf = */ n32FPrintf
};

// Shape redefined interface
static const AGW_SHAPE_CALLBACK_INTERFACE_STRUCT GsStormPositionCallback =
{
    /* eHasIntresection */ eStormPositionHasIntersection
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _AGW_STORM_POSITION_OBJ_H_ */
