/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_FRONT_OBJ_H_
#define _AGW_FRONT_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_FRONT_OBJECT_NAME "AGW_FRONT"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_front_object_struct
{
    // Front type
    AGW_FRONT_TYPE_ENUM eType;

} AGW_FRONT_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static AGW_FRONT_TYPE_ENUM eType (
    AGW_FRONT_OBJECT hAgwFront
        );

static N32 n32FPrintf (
    AGW_FRONT_OBJECT hAgwFront,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_FRONT_OBJECT_INTERFACE_STRUCT AGW_FRONT = {
    /* eType = */ eType,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _AGW_FRONT_OBJ_H_
