/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is a utility file for parsing data from an XM AppID packet
 *
 ******************************************************************************/

#ifndef XMAPPID_PACKET_UTIL_H_
#define XMAPPID_PACKET_UTIL_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define XMAPPID_PACKET_CRC_FINAL_XOR_VALUE      (0xFFFF)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef UN8 XM_APPID;
typedef UN8 XM_SEQID;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
BOOLEAN XMAPPID_PACKET_UTIL_bParsePayloadFromPacket(
    OSAL_BUFFER_HDL hPacket,
    XM_APPID *ptAppID,
    XM_SEQID *ptSeqID
        );

#endif /* TRAFFIC_HIGHBAND_H_ */

