/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is a utility file for parsing data from a TDS Carousel
 *
 ******************************************************************************/

#ifndef TDS_UTIL_H_
#define TDS_UTIL_H_

#include "sms_api.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

typedef struct tds_util_object *TDS_UTIL_OBJECT;
#define TDS_UTIL_INVALID_OBJECT (TDS_UTIL_OBJECT)NULL

typedef struct tds_util_table_instance *TDS_UTIL_TABLE_INSTANCE;
#define TDS_UTIL_INVALID_TABLE_INSTANCE (TDS_UTIL_TABLE_INSTANCE)NULL

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef UN8 TDS_PVN;

typedef N16 TDS_TABLE_DEF_VERSION;
#define TDS_TABLE_INVALID_DEF_VERSION (TDS_TABLE_DEF_VERSION)(-1)

typedef N32 TDS_TABLE_CONTENT_VERSION;
#define TDS_TABLE_INVALID_CONTENT_VERSION (TDS_TABLE_CONTENT_VERSION)(-1)

typedef N8 TDS_CAROUSEL_ID;
#define TDS_INVALID_CAROUSEL_ID (TDS_CAROUSEL_ID)(-1)

typedef N16 TDS_TABLE_ID;
#define TDS_TABLE_INVALID_ID (TDS_TABLE_ID)(-1)

typedef N16 TDS_LABEL_ID;
#define TDS_LABEL_INVALID_ID (TDS_LABEL_ID)(-1)

typedef N16 TDS_TABLE_TIME;
#define TDS_INVALID_TABLE_TIME (TDS_TABLE_TIME)(-1)

typedef enum tds_data_type_enum
{
    TDS_DATA_TYPE_INT,
    TDS_DATA_TYPE_INT_ARRAY,
    TDS_DATA_TYPE_STRING,
    TDS_DATA_INVALID_TYPE

} TDS_DATA_TYPE_ENUM;

typedef struct tds_data_int_struct
{
    UN32 un32Data;

} TDS_DATA_INT_STRUCT;

typedef struct tds_data_string_struct
{
    STRING_OBJECT hString;

} TDS_DATA_STRING_STRUCT;

typedef struct tds_int_array_struct
{
    UN32 *pun32Integers;
    size_t tArraySize;

} TDS_INT_ARRAY_STRUCT;

typedef union tds_data_value_union
{
    TDS_DATA_INT_STRUCT sInt;
    TDS_INT_ARRAY_STRUCT sIntArray;
    TDS_DATA_STRING_STRUCT sString;

} TDS_DATA_VALUE_UNION;

typedef struct tds_column_struct
{
    TDS_LABEL_ID tLabelId;
    TDS_DATA_TYPE_ENUM eType;

} TDS_COLUMN_STRUCT;

typedef struct tds_column_entry_struct
{
    TDS_COLUMN_STRUCT sColumn;
    TDS_DATA_VALUE_UNION uData;

} TDS_COLUMN_ENTRY_STRUCT;

typedef enum tds_row_operation_enum
{
    TDS_ROW_OPERATION_START_ROW,
    TDS_ROW_OPERATION_END_ROW,
    TDS_ROW_OPERATION_INVALID

} TDS_ROW_OPERATION_ENUM;

typedef TDS_UTIL_TABLE_INSTANCE (*TDS_CREATE_TABLE_CALLBACK) (
    TDS_TABLE_ID tId,
    TDS_TABLE_DEF_VERSION tTabDefVer,
    TDS_TABLE_TIME tTimeInMinutes,
    void *pvCallbackArg
        );

typedef void (*TDS_DESTROY_TABLE_CALLBACK) (
    TDS_UTIL_TABLE_INSTANCE hTable
        );

typedef BOOLEAN (*TDS_ADD_COLUMN_CALLBACK) (
    TDS_UTIL_TABLE_INSTANCE hTable,
    BOOLEAN bLastColumn,
    TDS_COLUMN_STRUCT *psColumn,
    void *pvCallbackArg
        );

typedef BOOLEAN (*TDS_ROW_STATUS_CALLBACK) (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_ROW_OPERATION_ENUM eRowOperation,
    void *pvCallbackArg
        );

typedef BOOLEAN (*TDS_ADD_ROW_DATA_CALLBACK) (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_COLUMN_ENTRY_STRUCT *psColumnEntry,
    void *pvCallbackArg
        );

typedef BOOLEAN (*TDS_NEW_TABLE_READY_CALLBACK) (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_TABLE_CONTENT_VERSION tTabContentVer,
    void *pvCallbackArg
        );

typedef struct tds_callbacks_struct
{
    TDS_CREATE_TABLE_CALLBACK hCreateTable;
    TDS_DESTROY_TABLE_CALLBACK vDestroyTable;
    TDS_ADD_COLUMN_CALLBACK bAddColumn;
    TDS_ROW_STATUS_CALLBACK bRowStatus;
    TDS_ADD_ROW_DATA_CALLBACK bAddRowData;
    TDS_NEW_TABLE_READY_CALLBACK bNewTable;
    void *pvTableArg;

} TDS_CALLBACKS_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

typedef struct tds_table_desc_struct
{
    TDS_TABLE_ID tId;
    TDS_TABLE_DEF_VERSION tDefVer;
    TDS_TABLE_CONTENT_VERSION tContentVer;
    TDS_CAROUSEL_ID tDefCarouselId;
    TDS_CAROUSEL_ID tContentCarouselId;

} TDS_TABLE_DESC_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

// Get a connection to TDS -- provide a version and maybe some more stuff
TDS_UTIL_OBJECT TDS_UTIL_hConnect (
    SMS_OBJECT hTDSParent,
    SMS_OBJECT hRowDataParent,
    TDS_CALLBACKS_STRUCT *psCallbacks,
    BOOLEAN bRestrictTables
        );

BOOLEAN TDS_UTIL_bRegisterTable (
    TDS_UTIL_OBJECT hTDS,
    TDS_TABLE_DESC_STRUCT *psTable
        );

BOOLEAN TDS_UTIL_bSetScodeLUT (
    TDS_UTIL_OBJECT hTDS,
    const char **ppacSCodeLUT,
    size_t tNumEntriesInLUT
        );

void TDS_UTIL_vDisconnect(
    TDS_UTIL_OBJECT hTDS
        );

BOOLEAN TDS_UTIL_bProcessPayload (
    TDS_UTIL_OBJECT hTDS,
    OSAL_BUFFER_HDL hPayload
        );

char const *TDS_UTIL_pacDataType (
    TDS_DATA_TYPE_ENUM eType
        );

#endif /* TDS_UTIL_H_ */

