/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file contains the scode lookup table used for Phonetics in conjunction
 *  with TDS
 *
 ******************************************************************************/

#ifndef SCODES_H_
#define SCODES_H_

#include "standard.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

#define SCODE_TABLE_NUM_ENTRIES \
    (sizeof(GasSCodeLUT) / sizeof(const char *))

static const char *GasSCodeLUT[] =
{
    // Character mappings
    "\0", " ", ".", "\"",  "%", "~", "2", "3", "4", "9", "@", "{", "a", "b", "d", "e", "f", "g", "h",
    "?",  "i", "j", "j\\", "k", "l", "m", "n", "o", "p", "r", "s", "t", "u", "v", "w", "x", "y", "z",
    "A",  "B", "D", "E",   "G", "H", "I", "J", "Y", "N", "O", "R", "S", "T", "U", "V", "Z", "tS", "`",

    // Commonly used string mappings
    "D@", // The
    " \"", // Some kind of vocal space
    "\"sports", // Sports
    "hVn.drEd", // Hundred
    "re.di.o", // Radio
    "sI.ri.@s", // Sirius
    "Eks.\"Em" // XM
};

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* SCODES_H_ */

