/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _WS_ALERTS_PVN1_H_
#define _WS_ALERTS_PVN1_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include <stdio.h>

#include "sms_api.h"
#include "rfd_interface_obj.h"
#include "ws_alerts_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// PVN 1 - Definitions
#define WS_ALERTS1_OBJECT_NAME "WSAlerts1"

// The protocol version supported
// by SMS for this interface
#define WS_ALERTS1_PVN (1)
#define WS_ALERTS1_DSI (441)

#define WS_ALERTS1_SHARED_BUFFER_LEN (256)

// DB file extension
#define WS_ALERTS1_DB_FILE_EXT ".db"
#define WS_ALERTS1_MAX_FILE_NAME_LEN (32)

//WS_alerts Look Up tables class
#define WS_ALERTS1_LUT_CLASS_ALERT_TYPE 0
#define WS_ALERTS1_LUT_CLASS_ALERT_LOCATION 1
#define WS_ALERTS1_LUT_CLASS_COMMON_PHRASE_CODE 2

// As defined in rfd_receiver_config.h
#define WS_ALERTS1_RFD_CLIENT_ID    (5)

//General Access Unit Definitions
#define WS_ALERTS1_PVN_BITLEN (4)
#define WS_ALERTS1_CAROUSEL_BITLEN (3)
#define WS_ALERTS1_STATE_FLAG_BITLEN (1)
#define WS_ALERTS1_STATE_ID_BITLEN (7)
#define WS_ALERTS1_LANGUAGE_CODE_BITLEN (3)
#define WS_ALERTS1_STATE_VERSION_BITLEN (4)
#define WS_ALERTS1_CTSIZE_BITLEN (4)

#define WS_ALERTS1_LANGUAGE_OFFSET \
    (WS_ALERTS1_PVN_BITLEN + WS_ALERTS1_CAROUSEL_BITLEN + \
     WS_ALERTS1_STATE_FLAG_BITLEN + WS_ALERTS1_STATE_ID_BITLEN)

#define WS_ALERTS1_EPOCH_BITLEN (16)
#define WS_ALERTS1_ETIME_BITLEN (5)
#define WS_ALERTS1_ISIZE_BITLEN (4)

#define WS_ALERTS1_TAB_CLASS_BITLEN (8)
#define WS_ALERTS1_TAB_TABID_BITLEN (8)
#define WS_ALERTS1_TAB_TPSIZE_BITLEN (5)
#define WS_ALERTS1_TAB_TVMIN_BITLEN (7)
#define WS_ALERTS1_TAB_TABINDEX_BITLEN (8)

#define WS_ALERTS1_CRC_BYTELEN (4)
#define WS_ALERTS1_PRESENCE_FLAG_BITLEN (1)
#define WS_ALERTS1_TRIM_BITLEN \
    (WS_ALERTS1_PVN_BITLEN + WS_ALERTS1_CAROUSEL_BITLEN)

#define WS_ALERTS1_MSG_PAR_FIXED_BITLEN (8)
#define WS_ALERTS1_MSG_FMT_BITLEN (4)

#define WS_ALERTS1_MESSAGE_DELIMITER_ELEM_BITLEN (16)
#define WS_ALERTS1_START_TIME_ELEM_OSIZE_BITLEN (2)
#define WS_ALERTS1_POLYGON_ELEM_LOCNO_BITLEN (5)
#define WS_ALERTS1_POLYGON_ELEM_ANCHOR_LAT_BITLEN (14)
#define WS_ALERTS1_POLYGON_ELEM_ANCHOR_LON_BITLEN (14)
#define WS_ALERTS1_POLYGON_ELEM_DELTAP_LAT_BITLEN (9)
#define WS_ALERTS1_POLYGON_ELEM_DELTAP_LON_BITLEN (9)
#define WS_ALERTS1_PHONEME_ELEM_LENGTH_BITLEN (8)
#define WS_ALERTS1_FREE_TEXT_ELEM_MAX_SYMBOLS (128)
#define WS_ALERTS1_LARGE_CONTAINER_ELEM_LENGTH_BITLEN (8)
#define WS_ALERTS1_SMALL_CONTAINER_ELEM_LENGTH_BITLEN (8)
#define WS_ALERTS1_PHONE_NUMBER_ELEM_INT_BITLEN (2)
#define WS_ALERTS1_PHONE_NUMBER_ELEM_AREA_BITLEN (10)
#define WS_ALERTS1_PHONE_NUMBER_ELEM_EXCH_BITLEN (10)
#define WS_ALERTS1_PHONE_NUMBER_ELEM_NUM_BITLEN (14)
#define WS_ALERTS1_SYSTEM_PRIORITY_ELEM_SPRI_BITLEN (4)
#define WS_ALERTS1_DTYPE_STRING_SIZE (8)

// CRC Calculation
#define WS_ALERTS1_CRC_INVERSION_VALUE (0xFFFFFFFFL)

//Message element types
#define WS_ALERTS1_MESSAGE_DELIMITER_ELEM (0x0)
#define WS_ALERTS1_START_TIME_ELEM (0x1)
#define WS_ALERTS1_END_TIME_ELEM (0x2)
#define WS_ALERTS1_GENERIC_TIME_ELEM (0x3)
#define WS_ALERTS1_POLYGON_ELEM (0x4)
#define WS_ALERTS1_TEXT_LTR_ELEM (0x5)
#define WS_ALERTS1_TEXT_LTR_LC_ELEM (0x6)
#define WS_ALERTS1_TEXT_FIG_ELEM (0x7)
#define WS_ALERTS1_PHONEME_ELEM (0x8)
#define WS_ALERTS1_LARGE_CONTAINER_ELEM (0x9)
#define WS_ALERTS1_SMALL_CONTAINER_ELEM (0xA)
#define WS_ALERTS1_FILE_LINK_ELEM (0xB)
#define WS_ALERTS1_PHONE_NUMBER_ELEM (0xC)
#define WS_ALERTS1_SYSTEM_PRIORITY_ELEM (0xD)

//(00001000)
#define WS_ALERTS1_PARSER_FORMAT_CAP_MASK    (0x08)
//(00000110)
#define WS_ALERTS1_PARSER_FORMAT_TAIL_MASK   (0x06)
//(00000001)
#define WS_ALERTS1_PARSER_FORMAT_BREAK_MASK  (0x01)

//(00000000)
#define WS_ALERTS1_PARSER_FORMAT_TAIL_NO_SUFFIX    (0x00)
//(00000010)
#define WS_ALERTS1_PARSER_FORMAT_TAIL_SPACE        (0x02)
//(00000100)
#define WS_ALERTS1_PARSER_FORMAT_TAIL_COMMA_SPACE  (0x04)
//(00000110)
#define WS_ALERTS1_PARSER_FORMAT_TAIL_PERIOD_SPACE (0x06)

// Time related constants
#define WS_ALERTS1_EPOCH_TO_SECONDS_COEFF (60 * 60 * 24) //number of seconds in day
#define WS_ALERTS1_ETIME_TO_SECONDS_COEFF (60 * 60)      //number of seconds in hour
#define WS_ALERTS1_TIME_OFFSET_TO_SECONDS_COEFF (5 * 60) //number of seconds in 5 mins

#define WS_ALERTS1_VERTICES_MAX_NUM (32)
#define WS_ALERTS1_POLYGON_DELTA_MIN_NUM (1)
#define WS_ALERTS1_POLYGON_DELTA_MAX_NUM (30)

#define WS_ALERTS1_TABLE_DESCS_MAX_NUM (25)

#define WS_ALERTS1_PAYLOAD_FILE_NAME_LENGTH (9)

#define WS_ALERTS1_DTYPE_INT_MAX_BITLEN (16)

#define WS_ALERTS1_PHONE_NUMBER_STRING "%s%d%d%d"
#define WS_ALERTS1_PHONE_COUNTRY_ID_US (0)
#define WS_ALERTS1_PHONE_COUNTRY_ID_CANADA (1)
#define WS_ALERTS1_PHONE_COUNTRY_ID_MEXICO (2)
#define WS_ALERTS1_PHONE_COUNTRY_ID_STRING_US "+1"
#define WS_ALERTS1_PHONE_COUNTRY_ID_STRING_MEXICO "+52"

// RFD Constants
#define WS_ALERTS1_RFD_UPDATE_TOKEN 'U'
#define WS_ALERTS1_RFD_UPDATE_NAME_LEN (4)

#define WS_ALERTS1_RFD_FLAGS_BITLEN (8)
#define WS_ALERTS1_PARTITIONS_BITLEN (8)
#define WS_ALERTS1_PARTITION_CLASS_BITLEN (8)
#define WS_ALERTS1_PARTITION_TAB_BITLEN (8)
#define WS_ALERTS1_PARTITION_LANG_BITLEN (8)
#define WS_ALERTS1_PARTITION_VER_MIN_BITLEN (16)
#define WS_ALERTS1_PARTITION_UPDATE_VER_BITLEN (16)
#define WS_ALERTS1_PARTITION_PAR_INDEX_BITLEN (32)

#define WS_ALERTS1_PARTITION_LBNO_BITLEN (6)
#define WS_ALERTS1_PARTITION_LBNID_BITLEN (8)

#define WS_ALERTS1_PARTITION_DTYPE_BITLEN (3)
#define WS_ALERTS1_PARTITION_LBSIZE_BITLEN (12)
#define WS_ALERTS1_PARTITION_ARRAYNO_BITLEN (6)

#define WS_ALERTS_CLASS1_LABID_LON (4)
#define WS_ALERTS_CLASS1_LABID_LAT (3)

#define WS_ALERTS1_UPDATE_UTYPE_BITLEN (2)
#define WS_ALERTS1_UPDATE_FLAG_BITLEN (1)

// Transformation of lon which represents a positive offset from
// a longitude of -178 degrees and is a number of 1/128th of
// a degree to integer multiplying it by 2^22
// ( -178 + lon * (1/128) ) * 2^22
#define WS_ALERTS1_POLYGON_ANCHOR_LON_INT(lon) \
   (N32)(((lon) - (178<<7))<<15)

// Transformation of lat which represents a number of 1/128th of
// a degree to integer multiplying it by 2^22
// ( lat * (1/128) ) * 2^22
#define WS_ALERTS1_POLYGON_ANCHOR_LAT_INT(lat) \
   (N32)((lat)<<15)

// transformation for delta points the same as for latitude
#define WS_ALERTS1_POLYGON_DELTAP_LON_INT(lon) \
   (N32)((lon)<<15)
#define WS_ALERTS1_POLYGON_DELTAP_LAT_INT(lat) \
   (N32)((lat)<<15)


// Transformation of lon which represents a positive offset from
// a longitude of -178 degrees and is a number of 1/128th of
// a degree to integer multiplying it by 2^22
// ( -178 + lon * (1/128) ) * 2^22
#define WS_ALERTS1_LON_INT(lon) \
   (N32)(((lon) - (178<<7))<<15)

// Transformation of lat which represents a number of 1/128th of
// a degree to integer multiplying it by 2^22
// ( lat * (1/128) ) * 2^22
#define WS_ALERTS1_LAT_INT(lat) \
   (N32)((lat)<<15)

#define WS_ALERTS1_GENERATE_STATE_ID(X,Y) ((X << 7) | (Y))

typedef enum ws_alerts1_update_utype_enum
{
    WS_ALERTS1_UPDATE_UTYPE_DELETE = 0,
    WS_ALERTS1_UPDATE_UTYPE_NEW,
    WS_ALERTS1_UPDATE_UTYPE_MODIFY,
    WS_ALERTS1_UPDATE_UTYPE_END

} WS_ALERTS1_UPDATE_UTYPE_ENUM;

// Calculated by the max size of an update
// entry, rounded up to the nearest power of 2
#define WS_ALERTS1_RFD_READ_BLOCK_SIZE (2048)

#define WS_ALERTS1_BUFFER_SIZE (2048)

#define WS_ALERTS1_FILE_NAME_ID_LABEL "%08x"

// Constant which defines the bit width of the maximum file update
// version, which is then passed to RFD_INTERFACE_hConnect.
// This is used in determining the applicability of incoming
// RFD updates.
// Note: 999 => 11 1110 0111 = 10 bits
#define WS_ALERTS1_MAX_VERSION_BITLEN ( 10 )

/* Max message sizes (from SX-9845-0023)
*   Section 4.3 says:
*       The maximum size of any Access Unit is 5120 bytes.
*
*   In addition, let's make sure we have enough memory for
*   a few queued messages -- let's say 4.
*/
#define WS_ALERTS1_HIGH_RATE_PAYLOAD_MAX_SIZE (5120 * 4)
#define WS_ALERTS1_NORM_RATE_PAYLOAD_MAX_SIZE (5120 * 4)
#define WS_ALERTS1_RFD_META_PAYLOAD_MAX_SIZE (5120)
#define WS_ALERTS1_RFD_BLOCK_PAYLOAD_MAX_SIZE (5120)

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum ws_alerts1_msg_type_enum
{
    WS_ALERTS1_HIGH_RATE_MSG = 0,
    WS_ALERTS1_NORMAL_RATE_MSG,
    WS_ALERTS1_DB_UPDATE_MSG,
    WS_ALERTS1_METADATA_UPDATE_MSG,
    WS_ALERTS1_INVALID_MSG
} WS_ALERTS1_MSG_CAROUSEL_ENUM;

typedef struct ws_alerts1_au_data_struct
{
    WS_ALERTS1_MSG_CAROUSEL_ENUM eCarouselID;
    BOOLEAN bSTATEFLAG;
    UN8 un8STATE;
    SMS_LANGUAGE_ENUM eLANG;
    UN8 un8STVER;
    UN16 un16AUTOT;
    UN16 un16AUCT;
    UN16 un16EPOCH;
    UN32 un32CRC;
    OSAL_BUFFER_HDL hPayload;
} WS_ALERTS1_AU_DATA_STRUCT;

typedef struct ws_alerts1_rfd_ctrl_struct
{
    // Handle to the top-level ws alerts service
    WS_ALERTS_SERVICE_OBJECT hWSAlertsService;

    RFD_INTERFACE_OBJECT hRFD;

    // Our path / connection to the DB under construction
    SQL_INTERFACE_OBJECT hDBConnection;
    STRING_OBJECT hDBPath;

    // Progress tracking
    RFD_UPDATE_VERSION tCurrentVersion;
    RFD_PROGRESS_INDEX tCurProgressIndex;
    RFD_PROGRESS_INDEX tStartProgressIndex;
    UN8 un8NumStatesInUpdate;

    // List of update file partitions
    OSAL_OBJECT_HDL hPartsList;

    // Partition entry which is currently processed
    OSAL_LINKED_LIST_ENTRY hCurrentPartEntry;

    // The block pool used to process RFD files
    OSAL_OBJECT_HDL hBlockPool;

    // The buffer used to access the block pool
    OSAL_BUFFER_HDL hBuffer;

    OSAL_FIXED_OBJECT hDegDivsor;
    OSAL_FIXED_OBJECT hLonBase;

    // Command buffer used to generate commands
    char acSQLCommandBuffer[WS_ALERTS_MAX_SQL_STRING_LENGTH];

} WS_ALERTS1_RFD_CTRL_STRUCT;

typedef struct ws_alerts1_polygon_definition_struct
{
    UN8 un8LOCNO;
    UN16 un16ANCHORLat;
    UN16 un16ANCHORLon;
    N16 n16DELTAPLat[WS_ALERTS1_VERTICES_MAX_NUM - 1];
    N16 n16DELTAPLon[WS_ALERTS1_VERTICES_MAX_NUM - 1];

} WS_ALERTS1_POLYGON_DEFINITION_STRUCT;

typedef struct ws_alerts1_phone_number_struct
{
    UN8 un8INT;
    UN16 un16AREA;
    UN16 un16EXCH;
    UN16 un16NUM;

} WS_ALERTS1_PHONE_NUMBER_STRUCT;

typedef struct ws_alerts1_message_element_struct
{
    UN16 tINDEX;
    UN16 tPAR;
    UN8 tFMT;

    union
    {
        UN16 un16MSGSIG;
        UN16 un16TimeOffset;

        WS_ALERTS1_POLYGON_DEFINITION_STRUCT sPolygon;
        STRING_OBJECT hFreeText;
        STRING_OBJECT hPhoneme;
        OSAL_OBJECT_HDL hLargeCont;
        OSAL_OBJECT_HDL hSmallCont;
        STRING_OBJECT hFileLink;
        STRING_OBJECT hPhoneNum;
        UN8 un8SPRI;
    } uData;

} WS_ALERTS1_MESSAGE_ELEMENT_STRUCT;

typedef struct ws_alerts1_tab_desc_struct
{
    UN16 tINDEX;
    UN8 tCLASS;
    UN8 tTABID;
    UN8 tTPSIZE;
    UN8 tTVMIN;
    UN8 tTABINDEX;
} WS_ALERTS1_TABLE_DESC_STRUCT;

typedef struct ws_alerts1_parsed_au_struct
{
    UN8 un8ETIME;
    UN8 un8ISIZE;
    UN16 un16TABNO;
    WS_ALERTS1_TABLE_DESC_STRUCT asTabDesc[WS_ALERTS1_TABLE_DESCS_MAX_NUM + 1 /*INDEX=1, fake*/];
    OSAL_OBJECT_HDL hMsgElementsList;
} WS_ALERTS1_PARSED_AU_STRUCT;

typedef struct ws_alerts1_msg_desc_struct
{
    UN8 un8StateId;
    SMS_LANGUAGE_ENUM eLANG;
    UN16 un16EPOCH;
    UN8 un8Version;
    UN16 un16AUTotal;
    BOOLEAN bProcessed;
    OSAL_OBJECT_HDL hUnParsedAUsList;
} WS_ALERTS1_STATE_MSG_DESC_STRUCT;

typedef struct ws_alerts1_unparsed_au_struct
{
    BOOLEAN bParsed;
    UN16 un16AUCT;
    UN32 un32CRC;
    OSAL_BUFFER_HDL hPayload;
    char acFilename[WS_ALERTS1_PAYLOAD_FILE_NAME_LENGTH];
    UN8 un8NumTailBits;
} WS_ALERTS1_UNPARSED_AU_STRUCT;

// Interface definition
typedef struct ws_alerts1_object_struct
{
    // Handle to the top-level ws_alerts service
    WS_ALERTS_SERVICE_OBJECT hWSAlertsService;

    // CRC handle (used to compute ISO 3309 CRC32 based CRCs)
    OSAL_OBJECT_HDL hCRC;

    RFD_INTERFACE_OBJECT hRFD;

    //stores current AU's header and unparsed payload
    WS_ALERTS1_AU_DATA_STRUCT sAUData;

    char *pacServiceFilePath;

    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psCurStateMsgDesc;

    //List of messages received from
    //high carousel grouped by state
    OSAL_OBJECT_HDL hStateMsgHighList;

    //List of messages received from
    //normal carousel grouped by state
    OSAL_OBJECT_HDL hStateMsgNormalList;

    // The block pool used by AU parser
    OSAL_OBJECT_HDL hBlockPool;

    // Shared buffer
    char acBuffer[WS_ALERTS1_SHARED_BUFFER_LEN];

    // The buffer used to access the block pool
    OSAL_BUFFER_HDL hBuffer;

    // The CRC value for the current message
    UN32 un32CurrentMsgCRC;

    SMS_LANGUAGE_ENUM eCurrentLanguage;

    BOOLEAN bProcessCurAU;

    WS_ALERTS1_PARSED_AU_STRUCT *psParsedAUDesc;

} WS_ALERTS1_OBJECT_STRUCT;

typedef struct ws_alerts1_au_check_iterator_struct
{
    WS_ALERTS1_OBJECT_STRUCT *psObj;
    BOOLEAN bIsAlertTypePresent;
    BOOLEAN bIsAlertLocationPresent;
    BOOLEAN bSuccess;
} WS_ALERTS1_AU_CHECK_ITERATOR_STRUCT;

typedef struct ws_alerts1_msg_elem_iterator_struct
{
    WS_ALERTS1_OBJECT_STRUCT *psObj;
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc;
    WS_ALERTS_MSG_SET_DESC_STRUCT *psMsgSetDesc;
    BOOLEAN bResult;
} WS_ALERTS1_MSG_ELEM_ITERATOR_STRUCT;

typedef struct ws_alerts1_iterator_data_struct
{
    WS_ALERTS1_OBJECT_STRUCT *psObj;
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc;
    BOOLEAN bRemoveMsgsFromDB;
} WS_ALERTS1_ITERATOR_DATA_STRUCT;


//RFD typedefs
typedef enum ws_alerts1_partition_dtype_enum
{
    WS_ALERTS1_PARTITION_DTYPE_INT = 0,
    WS_ALERTS1_PARTITION_DTYPE_STRING,
    WS_ALERTS1_PARTITION_DTYPE_BAUDOT_STRING,
    WS_ALERTS1_PARTITION_DTYPE_ARRAY_OF_INT
} WS_ALERTS1_PARTITION_DTYPE_ENUM;

// Structure which specifies all attributes
// of a single column in lookup table
typedef struct ws_alerts1_label_desc_struct
{
    UN8 un8LabelId;
    STRING_OBJECT hLbText;
    UN8 un8DataType;
    UN16 un16LbSize;
    UN8 un8ArrayNum;
    WS_ALERTS_LABEL_VALUE_UNION uCurLbValue;
    size_t tCurrentArrayNum;
    BOOLEAN bPresence;
} WS_ALERTS1_LABEL_DESC_STRUCT;

// Structure which specifies all attributes
// of a single partition
typedef struct ws_alerts1_parition_desc_struct
{
    UN8 un8Class;
    UN8 un8Tab;
    UN8 un8Lang;
    UN16 un16VerMin;
    UN16 un16UpdateVer; // Partition update version
    UN32 un32ByteSeekOffset;    // Offset from file beginning in bytes
    UN8 un8NumOfLabels;
    OSAL_OBJECT_HDL hLabelsList; //list of WS_ALERTS1_LABEL_DESC_STRUCT
} WS_ALERTS1_PARTITION_DESC_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

// Public interface APIs

static size_t tMinimumOTABufferByteSize (
    BOOLEAN bDBUpdatesEnabled
        );

static WS_ALERTS_INTERFACE_OBJECT hInit(
    WS_ALERTS_SERVICE_OBJECT hAlertsService,
    SMS_OBJECT hParent,
    SQL_INTERFACE_OBJECT hSQLRefConnection,
    RFD_UPDATE_VERSION tCurrentVersion,
    BOOLEAN bDBUpdatesEnabled
        );

static void vUnInit(
    WS_ALERTS_INTERFACE_OBJECT hInterface
        );

static BOOLEAN bProcessMessage(
    WS_ALERTS_INTERFACE_OBJECT hInterface,
    OSAL_BUFFER_HDL *phPayload
        );

//Private functions

static WS_ALERTS1_MSG_CAROUSEL_ENUM eGetMessageType (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_BUFFER_HDL hPayload
        );

static BOOLEAN bParseMessageHeader (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_BUFFER_HDL hPayload,
    WS_ALERTS1_MSG_CAROUSEL_ENUM eMessageType
        );

static SMSAPI_RETURN_CODE_ENUM eParseWSAlertsHeader (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_BUFFER_HDL hPayload
        );

static SMSAPI_RETURN_CODE_ENUM eAddAccessUnitToStorage (
    WS_ALERTS1_OBJECT_STRUCT *psObj
        );

static void vRenewStateMsg(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc
        );

static BOOLEAN bCompleteParseAUHeader (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_BUFFER_HDL hPayload
        );

static BOOLEAN bParseAUPayload (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_BUFFER_HDL hPayload
        );

static BOOLEAN bCopyLabelValues(
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc,
    WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
        );

static BOOLEAN bReadFlag(
    WS_ALERTS1_RFD_CTRL_STRUCT *psObj
        );

static BOOLEAN bCheckAU (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_OBJECT_HDL hMsgElementsList
        );

static BOOLEAN bPlacePayloadToFile(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_UNPARSED_AU_STRUCT *psUnParsedAUDesc
        );

static BOOLEAN bGetPayloadFromFile(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_UNPARSED_AU_STRUCT *psUnParsedAUDesc
        );

static WS_ALERTS1_TABLE_DESC_STRUCT* psGetTable(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    UN16 un16Index
        );

static UN8 u8GetPARLength (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    UN16 un16Index
        );

static BOOLEAN bGetFreeText(
    SMS_OBJECT hStringOwner,
    OSAL_BUFFER_HDL hPayload,
    STRING_OBJECT *phText,
    BOOLEAN bStringStartsWithLetters,
    BOOLEAN bStringStartsWithCaps
        );

static N16 n16WSAlertsFindByStateId (
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsg1,
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsg2
        );

static N16 n16CompareAUsByAUCT(
    WS_ALERTS1_UNPARSED_AU_STRUCT *psObj1,
    WS_ALERTS1_UNPARSED_AU_STRUCT *psObj2
        );

static BOOLEAN bProcessAU(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc,
    BOOLEAN bRemoveMsgsFromDB
        );

static BOOLEAN bIterateMsgElements(
    WS_ALERTS1_MESSAGE_ELEMENT_STRUCT *psPvnMsgElem,
    WS_ALERTS1_MSG_ELEM_ITERATOR_STRUCT *psIterator
        );

static void vReleaseMsgSet(
    WS_ALERTS_MSG_SET_DESC_STRUCT *psMsgSetDesc
        );

static BOOLEAN bFillMsgData(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc,
    WS_ALERTS1_MESSAGE_ELEMENT_STRUCT *psPvnMsgElem,
    WS_ALERTS_MGR_MESSAGE_ELEMENT_STRUCT *psMgrMsgElem,
    WS_ALERTS1_TABLE_DESC_STRUCT *psLookUpTable
        );

static TIME_T tGetDateTime(
    UN16 un16Epoch,
    UN8 un8ETime,
    UN16 un16Offset
        );

static BOOLEAN bBuildServiceFilePath(
    WS_ALERTS1_OBJECT_STRUCT *psObj
        );

static WS_ALERTS1_STATE_MSG_DESC_STRUCT *psWSAlertsGetStateMsgDesc(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    BOOLEAN *pbStateMsgDescChanged
        );

static void vReleaseStateMsgList (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_OBJECT_HDL *phStateMsgList
        );

static void vReleaseStateMsg (
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_STATE_MSG_DESC_STRUCT *psStateMsgDesc
        );

static void vReleaseUnParsedAUsList(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    OSAL_OBJECT_HDL hAUList
        );

static void  vReleaseUnParsedAU(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    WS_ALERTS1_UNPARSED_AU_STRUCT *psAuDesc
        );

static void vReleaseParsedAU(
    WS_ALERTS1_PARSED_AU_STRUCT *psAuDesc
        );

static void vReleaseMsgElement (
    WS_ALERTS1_MESSAGE_ELEMENT_STRUCT *psMsgElement
        );

static BOOLEAN bAuCheckIterator (
    WS_ALERTS1_MESSAGE_ELEMENT_STRUCT *psMsgElem,
    WS_ALERTS1_AU_CHECK_ITERATOR_STRUCT *psIterator
        );

static RFD_PROCESS_RESULT_ENUM eRFDFileProcessor (
    RFD_INTERFACE_OBJECT hConnection,
    RFD_PROCESS_STATUS_ENUM eProcessStatus,
    FILE *psRFDFile,
    RFD_UPDATE_VERSION tFileVersion,
    RFD_PROGRESS_INDEX tProgressIndex,
    void *pvCallbackArg
        );

static RFD_FILE_STATUS_ENUM eRFDUpdateNeeded (
    RFD_INTERFACE_OBJECT hConnection,
    const char *pcFileName,
    RFD_UPDATE_VERSION *ptFileVersion,
    size_t tVersionBitWidth,
    void *pvCallbackArg
        );

static BOOLEAN bGetFileVersionFromName(
    const char *pcFileName,
    RFD_UPDATE_VERSION *ptNewVersion
        );

static WS_ALERTS1_RFD_CTRL_STRUCT *psCreateRFDCtrl(
    WS_ALERTS1_OBJECT_STRUCT *psObj
        );

static BOOLEAN bInitRFD(
    WS_ALERTS1_OBJECT_STRUCT *psObj,
    RFD_UPDATE_VERSION tCurrentVersion
        );

static BOOLEAN bInitRFDCtrl (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    RFD_INTERFACE_OBJECT hRFD,
    RFD_PROGRESS_INDEX tStartingIndex
        );

static void vUninitRFDCtrl (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl
        );

static void vDestroyRFDCtrl (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl
        );

static BOOLEAN bProcessRFDHeader (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    FILE *psRFDFile
        );

static RFD_PROCESS_RESULT_ENUM eProcessNextRFDEntry (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    FILE *psFile,
    RFD_UPDATE_VERSION tUpdateVersion
        );

static BOOLEAN bConnectToDB (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    BOOLEAN bPerformIntegrityCheck
        );

static BOOLEAN bFinalizeDB (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl
        );

static void vDeleteDB (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl
        );

static BOOLEAN bGetPartsList(
    WS_ALERTS1_RFD_CTRL_STRUCT *psObj,
    OSAL_OBJECT_HDL hPartsList
        );

static RFD_PROCESS_RESULT_ENUM eProcessUpdateGroup (
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    FILE *psFile
        );

static BOOLEAN bInitLutUpdateDesc(
    WS_ALERTS1_RFD_CTRL_STRUCT *psRFDCtrl,
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc,
    WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
        );

static BOOLEAN bGetLabelsList(
    WS_ALERTS1_RFD_CTRL_STRUCT *psObj,
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc,
    FILE *psFile
        );

static BOOLEAN bPerformUpdate(
    WS_ALERTS1_RFD_CTRL_STRUCT *psObj,
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc,
    WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc,
    FILE *psFile
        );

static BOOLEAN bGetLabelValue(
    WS_ALERTS1_RFD_CTRL_STRUCT *psObj,
    WS_ALERTS1_LABEL_DESC_STRUCT *psLabelDesc,
    FILE *psFile
        );

static void vReleaseLabel(
    WS_ALERTS1_LABEL_DESC_STRUCT *psLabelDesc
        );

static void vNotifyDBExpired (
    RFD_INTERFACE_OBJECT hConnection,
    void *pvCallbackArg
        );

static void vReleaseLutUpdateDesc(
    WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
        );

static void vReleasePartDesc(
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc
        );

static void vReleaseLabelsList(
    OSAL_OBJECT_HDL hLabelsList
        );

static void vReleaseLabel(
    WS_ALERTS1_LABEL_DESC_STRUCT *psLabelDesc
        );

static BOOLEAN bReleaseLabelData(
    WS_ALERTS1_LABEL_DESC_STRUCT *psLabelDesc
        );

static BOOLEAN bCleanDbDir (
    WS_ALERTS1_OBJECT_STRUCT *psObj
        );

static BOOLEAN bFileQualifier (
    const char *pcItemName,
    const void *pvArg
        );

static void vDestroyMessageElement (
    WS_ALERTS_MGR_MESSAGE_ELEMENT_STRUCT *psMsgElement
        );

static BOOLEAN bProcessAuIterator (
    WS_ALERTS1_UNPARSED_AU_STRUCT *psUnParsedAUDesc,
    WS_ALERTS1_ITERATOR_DATA_STRUCT *psIteratorData
        );

#if (DEBUG_OBJECT == 1)

static void vPrintPartitionInfo(
    WS_ALERTS1_PARTITION_DESC_STRUCT *psPartDesc
        );

static void vPrintLabelInfo(
    WS_ALERTS1_LABEL_DESC_STRUCT *psLabelDesc
        );

static void vPrintBuffer(
    OSAL_BUFFER_HDL hPayload
        );

static void vPrintBufferToFile(
    OSAL_BUFFER_HDL hPayload
        );
#endif

  /***************/
 /** VARIABLES **/
/***************/
const WS_ALERTS_PLUGIN_INTERFACE_STRUCT GsWSAlertsIntf =
{
    /*.tDSI = */WS_ALERTS1_DSI,
    /*.tMaxVersionBitlen =*/WS_ALERTS1_MAX_VERSION_BITLEN,
    /*.tMinimumOTABufferByteSize = */tMinimumOTABufferByteSize,
    /*.hInit = */hInit,
    /*.bProcessMessage = */bProcessMessage,
    /*.vUninit = */vUnInit
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _WS_ALERTS_PVN1_H_
