/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _PHONETICS_HIGHBAND_H_
#define _PHONETICS_HIGHBAND_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "tds_util.h"
#include "phonetics_interface.h"

  /************************/
 /** CONSTANTS / MACROS **/
/************************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define PHONETICS_HIGHBAND_OBJECT_NAME "Phonetics:HB"
#define PHONETICS_DSI            (330)

/* Max message sizes (from SX-9845-0246)
*   Section 4.3 says:
*       The maximum size of any Access Unit is 5120 bytes
*
*   There are two carousels, so we just need twice
*   that allocated for this service.
*
*
*   In addition, let's make sure we have enough memory for
*   a few queued messages -- let's say 4.
*/
#define PHONETICS_HIGHBAND_BUFFER_BYTESIZE (5120 * 2 * 4)

// Definition Carousel Info
#define PHONETICS_HIGHBAND_DEF_CARID ((TDS_CAROUSEL_ID)0)

// Content Carousel Info
#define PHONETICS_HIGHBAND_CHAN_CONT_CARID ((TDS_CAROUSEL_ID)1)
#define PHONETICS_HIGHBAND_CAT_CONT_CARID ((TDS_CAROUSEL_ID)1)
#define PHONETICS_HIGHBAND_MARKET_CONT_CARID ((TDS_CAROUSEL_ID)1)
#define PHONETICS_HIGHBAND_TEAM_CONT_CARID ((TDS_CAROUSEL_ID)2)
#define PHONETICS_HIGHBAND_LEAGUE_CONT_CARID ((TDS_CAROUSEL_ID)2)

/* Table Column ID constants */
#define PHONETICS_COL_ID1 (0)
#define PHONETICS_COL_ID2 (1)
#define PHONETICS_COL_VER (2)
#define PHONETICS_COL_PHONE0 (3)
#define PHONETICS_COL_PHONE1 (4)
#define PHONETICS_COL_PHONE2 (5)
#define PHONETICS_COL_PHONE3 (6)
#define PHONETICS_COL_PHONE4 (7)
#define PHONETICS_COL_PHONE5 (8)
#define PHONETICS_COL_PHONE6 (9)
#define PHONETICS_COL_PHONE7 (10)
#define PHONETICS_COL_LANG0 (11)
#define PHONETICS_COL_LANG1 (12)
#define PHONETICS_COL_LANG2 (13)
#define PHONETICS_COL_LANG3 (14)
#define PHONETICS_COL_LANG4 (15)
#define PHONETICS_COL_LANG5 (16)
#define PHONETICS_COL_LANG6 (17)
#define PHONETICS_COL_LANG7 (18)

// The maximum number of phonetics we'll get from TDS
#define PHONETICS_MAX_PHONETIC_ENTRIES (8)

/* Phonetics/Langue entry to array index mappings */
#define PHONETICS_COL_ID_TO_INDEX(id) ((id) - PHONETICS_COL_PHONE0)
#define LANGUAGE_COL_ID_TO_INDEX(id) ((id) - PHONETICS_COL_LANG0)

/* Language Identifiers */
#define PHONETICS_LANG_ENG (0)
#define PHONETICS_LAN_ESP (1)
#define PHONETICS_LANG_FR (2)

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum phonetics_highband_label_enum
{
    PHONETICS_HIGHBAND_LABEL_ID1,
    PHONETICS_HIGHBAND_LABEL_ID2,
    PHONETICS_HIGHBAND_LABEL_EVER,
    PHONETICS_HIGHBAND_LABEL_PHONETICS,
    PHONETICS_HIGHBAND_LABEL_LANGUAGE,
    PHONETICS_HIGHBAND_UNKNOWN_LABEL

} PHONETICS_HIGHBAND_LABEL_ENUM;

// Interface definition
typedef struct phonetics_highband_object_struct
{
    // Handle to the top-level phonetics service
    PHONETICS_SERVICE_OBJECT hPhoneticsService;

    // Handle to the TDS object handling messaging
    // for us
    TDS_UTIL_OBJECT hTDS;

} PHONETICS_HIGHBAND_OBJECT_STRUCT;

// Structure used to aid in table manipulation
typedef struct phonetics_table_struct
{
    // The current definition version for this table
    TDS_TABLE_DEF_VERSION tDefVer;

    // The phonetics type associated with this table
    PHONETICS_FILE_TYPE_ENUM eType;

    // The current phonetics node
    // that is being worked on
    PHONETICS_LIST_NODE_STRUCT *psPhonetics;

    // Flag indicates if the above node
    // has been populated with data
    BOOLEAN bPhoneticsNodePopulated;

    // Convenient array storage for phonetics
    // given to us by TDS
    STRING_OBJECT ahPhonetics[PHONETICS_MAX_PHONETIC_ENTRIES];

    // The Phonetics list we're going to provide
    // to the phonetics manager which represents
    // the data in this table
    OSAL_OBJECT_HDL hList;

} PHONETICS_HIGHBAND_TABLE_STRUCT;

  /****************/
 /** PROTOTYPES **/
/****************/

// Public interface APIs

static PHONETICS_INTERFACE_OBJECT hInit(
    PHONETICS_SERVICE_OBJECT hPhoneticsService,
    SMS_OBJECT hParent
        );

static void vUninit (
    PHONETICS_INTERFACE_OBJECT hInterface
        );

static BOOLEAN bAddTable (
    PHONETICS_INTERFACE_OBJECT hInterface,
    PHONETICS_FILE_TYPE_ENUM eType,
    UN8 un8TableId,
    UN8 un8TableDefVer,
    UN16 un16TableContentVer
        );

static BOOLEAN bProcessMessage (
    PHONETICS_INTERFACE_OBJECT hInterface,
    OSAL_BUFFER_HDL hPayload
        );

/* Object Private Prototypes */

static BOOLEAN bValidateColumn (
    TDS_COLUMN_STRUCT *psColumn,
    PHONETICS_HIGHBAND_LABEL_ENUM *peLabelType
        );

/* TDS Callbacks*/
static TDS_UTIL_TABLE_INSTANCE hCreateTable (
    TDS_TABLE_ID tId,
    TDS_TABLE_DEF_VERSION tTabDefVer,
    TDS_TABLE_TIME tTimeInMinutes,
    PHONETICS_HIGHBAND_OBJECT_STRUCT *psObj
        );

static BOOLEAN bAddColumnToTable (
    TDS_UTIL_TABLE_INSTANCE hTable,
    BOOLEAN bLastColumn,
    TDS_COLUMN_STRUCT *psColumn,
    PHONETICS_HIGHBAND_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRowStatus (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_ROW_OPERATION_ENUM eRowOperation,
    PHONETICS_HIGHBAND_OBJECT_STRUCT *psObj
        );

static BOOLEAN bAddRowDataToTable (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_COLUMN_ENTRY_STRUCT *psColumnEntry,
    PHONETICS_HIGHBAND_OBJECT_STRUCT *psObj
        );

static void vDestroyTable (
    TDS_UTIL_TABLE_INSTANCE hTable
        );

static BOOLEAN bNewTableReady (
    TDS_UTIL_TABLE_INSTANCE hTable,
    TDS_TABLE_CONTENT_VERSION tTabContentVer,
    PHONETICS_HIGHBAND_OBJECT_STRUCT *psObj
        );

  /***************/
 /** VARIABLES **/
/***************/

const PHONETICS_PLUGIN_INTERFACE_STRUCT GsPhoneticsIntf =
{
    /*.tDSI = */              PHONETICS_DSI,
    /*.tOTABufferByteSize = */PHONETICS_HIGHBAND_BUFFER_BYTESIZE,
    /*.hInit = */             hInit,
    /*.vUninit = */           vUninit,
    /*.bAddTable = */         bAddTable,
    /*.bProcessMessage = */   bProcessMessage
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _PHONETICS_HIGHBAND_H_
