/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*   GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SXI_RW_H_
#define SXI_RW_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

/*
    SXI Layload Read/Write Macros

    SXI is by definition Big-Endian meaning "Big-end first"

    So, based on the endianess of this hos processor, we must use MACROS
    which abstract this detail to keep the code the same everywhere.

    See RX00223, Section 3.2.1, SXI Message Format

*/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN SXIAPI_bWriteString(
    OSAL_BUFFER_HDL hPayload,
    const char *pacString
        );

BOOLEAN SXIAPI_bReadString(
    OSAL_BUFFER_HDL hPayload,
    char *pacString,
    size_t tSize
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

__INLINE__ BOOLEAN SXIAPI_bWriteBoolean(OSAL_BUFFER_HDL hPayload, BOOLEAN bData);
__INLINE__ BOOLEAN SXIAPI_bWriteUint8(OSAL_BUFFER_HDL hPayload, UN8 un8Data);
__INLINE__ BOOLEAN SXIAPI_bWriteSint8(OSAL_BUFFER_HDL hPayload, N8 n8Data);
__INLINE__ BOOLEAN SXIAPI_bReadBoolean(OSAL_BUFFER_HDL hPayload, BOOLEAN *pbData);
__INLINE__ BOOLEAN SXIAPI_bReadUint8(OSAL_BUFFER_HDL hPayload, UN8 *pun8Data);
__INLINE__ BOOLEAN SXIAPI_bReadSint8(OSAL_BUFFER_HDL hPayload, N8 *pn8Data);
__INLINE__ BOOLEAN SXIAPI_bPeekUint8(OSAL_BUFFER_HDL hPayload, UN8 *pun8Data, size_t tOffset);
__INLINE__ BOOLEAN SXIAPI_bWriteUint16(OSAL_BUFFER_HDL hPayload, UN16 un16Data);
__INLINE__ BOOLEAN SXIAPI_bWriteSint16(OSAL_BUFFER_HDL hPayload, N16 n16Data);
__INLINE__ BOOLEAN SXIAPI_bWriteUint32(OSAL_BUFFER_HDL hPayload, UN32 un32Data);
__INLINE__ BOOLEAN SXIAPI_bWriteSint32(OSAL_BUFFER_HDL hPayload, N32 n32Data);
__INLINE__ BOOLEAN SXIAPI_bReadUint16(OSAL_BUFFER_HDL hPayload, UN16 *pun16Data);
__INLINE__ BOOLEAN SXIAPI_bPeekUint16(OSAL_BUFFER_HDL hPayload, UN16 *pun16Data, size_t tOffset);
__INLINE__ BOOLEAN SXIAPI_bReadSint16(OSAL_BUFFER_HDL hPayload, N16 *pn16Data);
__INLINE__ BOOLEAN SXIAPI_bReadUint32(OSAL_BUFFER_HDL hPayload, UN32 *pun32Data);
__INLINE__ BOOLEAN SXIAPI_bReadSint32(OSAL_BUFFER_HDL hPayload, N32 *pn32Data);
__INLINE__ BOOLEAN SXIAPI_bWriteBlob(OSAL_BUFFER_HDL hPayload, const void *pvBlob, size_t tSize);
#endif // SXI_RW_H_

