/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SXI ID header file.
 *
 ******************************************************************************/

#ifndef SXI_SPORTS_ID_H_
#define SXI_SPORTS_ID_H_

#include "cid_integer.h"
#include "cid_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct sports_parse_struct
{
    UN8 un8LeagueId;
    UN16 un16Team1;
    UN16 un16Team2;
    SPORTS_BROADCAST_ENUM eBCastType;
    UN8 un8BCastTeamIndex;
    BOOLEAN bFound;

} SPORTS_PARSE_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// External CID Type Interface (SXI IDs)
extern const CID_TYPE_INTERFACE_STRUCT GsSxiSportsId;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */


#endif /* SXI_SPORTS_ID_H_ */
