/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SXI ID header file.
 *
 ******************************************************************************/

#ifndef SXI_MARKET_ID_H_
#define SXI_MARKET_ID_H_

#include "cid_integer.h"
#include "cid_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct market_parse_struct
{
    UN32 un32MarketId;
    BOOLEAN bMktFound;

} MARKET_PARSE_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// External CID Type Interface (SXI IDs)
extern const CID_TYPE_INTERFACE_STRUCT GsSxiMarketId;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
CID_OBJECT SXI_MARKET_ID_hCreate (
    CID_POOL hCidPool,
    UN32 un32MarketId
        );

#endif /* SXI_MARKET_ID_H_ */
